/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.SecurityInfoType;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.DynAuthDasRequest;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SecurityInfo;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_AccessDenied
extends AbstractDASServiceTest {
    private DynamicAuthorizationConsultation dac;

    public DASServiceTest_AccessDenied(CseService pCseService) {
        super("DASService AccessDenied", pCseService);
    }

    @Override
    public void performTest() {
        this.dac = this.createDAS(this.getDasAE().getResourceID());
        if (this.dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        this.setExpectedNumberOfCall(1);
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(this);
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(this.dac.getResourceID());
        AE ae = this.createAE(dacis);
        if (ae == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create AE");
            return;
        }
        ResponsePrimitive response = this.retrieveEntity(ae.getResourceID(), "nom:password");
        if (!ResponseStatusCode.ACCESS_DENIED.equals(response.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unexpected ResponseCode, expecting " + ResponseStatusCode.OK + ", found =" + response.getResponseStatusCode());
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        List<AbstractDASServiceTest.Call> receivedCalls = this.getCalls();
        if (receivedCalls.size() != 1) {
            this.setState(Test.State.KO);
            this.setMessage("expecting 1 call, found " + receivedCalls.size());
            return;
        }
        AbstractDASServiceTest.Call receivedCall = receivedCalls.get(0);
        if (receivedCall.getDynAuthRequest() == null) {
            this.setMessage("request is null");
            this.setState(Test.State.KO);
            return;
        }
        if (!receivedCall.getDynAuthRequest().getTargetedResourceID().equals(ae.getResourceID())) {
            this.setState(Test.State.KO);
            this.setMessage("bad targetId, expecting " + ae.getResourceID() + ", found " + receivedCall.getDynAuthRequest().getTargetedResourceID());
            return;
        }
        if (!receivedCall.getDynAuthRequest().getOriginator().equals("nom:password")) {
            this.setState(Test.State.KO);
            this.setMessage("bad caller credentials, expecting:nom:password, found " + receivedCall.getDynAuthRequest().getOriginator());
            return;
        }
        if (!Operation.RETRIEVE.equals(receivedCall.getDynAuthRequest().getOperation())) {
            this.setState(Test.State.KO);
            this.setMessage("bad operation, expecting:" + Operation.RETRIEVE + ", found " + receivedCall.getDynAuthRequest().getOperation());
            return;
        }
        if (receivedCall.getDynAuthRequest().getTargetedResourceID() == null) {
            this.setState(Test.State.KO);
            this.setMessage("resourceEntity is null");
            return;
        }
        if (!ae.getResourceID().equals(receivedCall.getDynAuthRequest().getTargetedResourceID())) {
            this.setState(Test.State.KO);
            this.setMessage("bad resourceEntity id, expecting " + ae.getResourceID() + ", found:" + receivedCall.getDynAuthRequest().getTargetedResourceID());
            return;
        }
        this.setState(Test.State.OK);
    }

    @Override
    public ResponsePrimitive doExecute(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        if (!Operation.NOTIFY.equals(request.getOperation())) {
            response.setResponseStatusCode(ResponseStatusCode.OPERATION_NOT_ALLOWED);
            return response;
        }
        SecurityInfo securityInfo = null;
        try {
            securityInfo = (SecurityInfo)request.getContent();
            if (securityInfo == null) {
                response.setResponseStatusCode(ResponseStatusCode.CONTENTS_UNACCEPTABLE);
                return response;
            }
        }
        catch (ClassCastException e) {
            response.setResponseStatusCode(ResponseStatusCode.CONTENTS_UNACCEPTABLE);
            return response;
        }
        if (!SecurityInfoType.DYNAMIC_AUTHORIZATION_REQUEST.equals(securityInfo.getSecurityInfoType())) {
            response.setResponseStatusCode(ResponseStatusCode.CONTENTS_UNACCEPTABLE);
            return response;
        }
        DynAuthDasRequest dasRequest = securityInfo.getDasRequest();
        if (dasRequest == null) {
            response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
            return response;
        }
        AbstractDASServiceTest.Call call = new AbstractDASServiceTest.Call(this, dasRequest);
        this.addCall(call);
        response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
        return response;
    }
}

