/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.objectteams.otdt.debug.OTDebugElementsContainer;
import org.eclipse.objectteams.otdt.debug.TeamInstance;
import org.eclipse.objectteams.otdt.debug.ui.OTDebugImages;

public class TeamInstanceLabelProvider
extends VariableLabelProvider {
    protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (element instanceof TeamInstance) {
            IVariable variable = (IVariable)element;
            if (this.isNameColumn(columnId)) {
                return variable.getReferenceTypeName();
            }
            return this.getColumnText(variable, variable.getValue(), context, columnId);
        }
        return "<unknown element>";
    }

    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        if (this.isNameColumn(columnId)) {
            TeamInstance teamInstance = (TeamInstance)elementPath.getLastSegment();
            OTDebugElementsContainer _otDebugElementsContainer = (OTDebugElementsContainer)teamInstance.getLaunch().getAdapter(OTDebugElementsContainer.class);
            if (_otDebugElementsContainer != null && _otDebugElementsContainer.getTeamInstance((IJavaVariable)teamInstance) != null) {
                int activationState = teamInstance.getActivationState(_otDebugElementsContainer.getContext());
                return this.getImageForState(activationState);
            }
            return this.getImageForState(0);
        }
        return null;
    }

    private boolean isNameColumn(String columnId) {
        return columnId == null || "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId);
    }

    private ImageDescriptor getImageForState(int activationState) {
        switch (activationState) {
            case 0: {
                return OTDebugImages.get("icons/team_inact.gif");
            }
            case 1: {
                return OTDebugImages.get("icons/team_act_implicit.gif");
            }
            case 2: {
                return OTDebugImages.get("icons/team_act.gif");
            }
        }
        return OTDebugImages.get("icons/team_inact.gif");
    }
}

