/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.formatting.preferences;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.preferences.formatter.IModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.xtend.ide.formatting.preferences.AbstractModifyDialogTab;
import org.eclipse.xtend.ide.formatting.preferences.PreviewCode;
import org.eclipse.xtext.xbase.formatting.BasicFormatterPreferenceKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineWrapTab
extends AbstractModifyDialogTab {
    private Map<String, String> fPreviewPreferences;
    private static final String DEFAULT_PREVIEW_LINE_WRAP = "40";
    private Integer previewLineWidth = Integer.valueOf("40");
    @Inject
    private IDialogSettings fDialogSettings;
    public static final String PREF_PREVIEW_LINE_WIDTH = "preview.line.width";

    public LineWrapTab(IModifyDialogTabPage.IModificationListener modifyListener, Map<String, String> workingValues) {
        super(modifyListener, workingValues);
    }

    public void initPrefs() {
        String previewLineWidth = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = Maps.newHashMap();
        this.fPreviewPreferences.put(PREF_PREVIEW_LINE_WIDTH, previewLineWidth != null && previewLineWidth.trim().length() > 0 ? previewLineWidth.toString() : DEFAULT_PREVIEW_LINE_WRAP);
    }

    @Override
    protected String previewText() {
        return PreviewCode.lineWrappingPreviewText();
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, "General settings");
        this.createNumberPref((Composite)generalGroup, numColumns, "Maximum line width:", BasicFormatterPreferenceKeys.maxLineWidth);
    }

    @Override
    protected void doUpdatePreview() {
        String maxLineWidthKey = BasicFormatterPreferenceKeys.maxLineWidth.getId();
        Object normalSetting = this.fWorkingValues.get(maxLineWidthKey);
        String previewLineWidth = this.fPreviewPreferences.get(PREF_PREVIEW_LINE_WIDTH);
        this.formatterPreview.moveMarginToColumn(previewLineWidth);
        this.fWorkingValues.put(maxLineWidthKey, previewLineWidth);
        super.doUpdatePreview();
        this.fWorkingValues.put(maxLineWidthKey, normalSetting != null ? normalSetting.toString() : "");
    }

    @Override
    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        super.doCreatePreviewPane(composite, numColumns);
        this.formatterPreview.moveMarginToColumn(this.previewLineWidth.toString());
        ModifyDialogTabPage.NumberPreference previewLineWidth = new ModifyDialogTabPage.NumberPreference((ModifyDialogTabPage)this, composite, numColumns / 2, this.fPreviewPreferences, PREF_PREVIEW_LINE_WIDTH, 0, 999, "Line width for preview");
        this.fDefaultFocusManager.add((ModifyDialogTabPage.Preference)previewLineWidth);
        previewLineWidth.addObserver(this.fUpdater);
        previewLineWidth.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (LineWrapTab.this.fDialogSettings != null) {
                    LineWrapTab.this.fDialogSettings.put(LineWrapTab.PREF_PREVIEW_LINE_WIDTH, (String)LineWrapTab.this.fPreviewPreferences.get(LineWrapTab.PREF_PREVIEW_LINE_WIDTH));
                }
            }
        });
        return composite;
    }
}

