/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.inject.Injector;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.builder.standalone.ILanguageConfiguration;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageAccessFactory {
    public Map<String, LanguageAccess> createLanguageAccess(List<? extends ILanguageConfiguration> languageConfigs, ClassLoader compilerClassLoder, File baseDir) {
        HashMap<String, LanguageAccess> result = new HashMap<String, LanguageAccess>();
        for (ILanguageConfiguration iLanguageConfiguration : languageConfigs) {
            ISetup setup;
            try {
                Class<?> loadClass = compilerClassLoder.loadClass(iLanguageConfiguration.getSetup());
                if (!ISetup.class.isAssignableFrom(loadClass)) {
                    throw new IllegalArgumentException("Language setup class " + iLanguageConfiguration.getSetup() + " must implement " + ISetup.class.getName());
                }
                setup = (ISetup)loadClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load language setup for class '" + iLanguageConfiguration.getSetup() + "'.", e);
            }
            Injector injector = setup.createInjectorAndDoEMFRegistration();
            IResourceServiceProvider serviceProvider = (IResourceServiceProvider)injector.getInstance(IResourceServiceProvider.class);
            FileExtensionProvider fileExtensionProvider = (FileExtensionProvider)injector.getInstance(FileExtensionProvider.class);
            LanguageAccess languageAccess = new LanguageAccess(iLanguageConfiguration.getOutputConfigurations(), serviceProvider, iLanguageConfiguration.isJavaSupport(), baseDir);
            for (String extension : fileExtensionProvider.getFileExtensions()) {
                result.put(extension, languageAccess);
            }
        }
        return result;
    }
}

