/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.registry;

import com.google.common.collect.Maps;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codetemplates.ui.highlighting.TemplateBodyHighlighter;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.PartialContentAssistContextFactory;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LanguageRegistry {
    private Map<String, Language> registeredLanguages = Maps.newHashMap();

    void register(Grammar grammar, Provider<TemplateBodyHighlighter> highlighter, ContextTypeRegistry registry, ContextTypeIdHelper helper, Provider<PartialContentAssistContextFactory> partialContentAssistContextFactory, String primaryFileExtension) {
        Language language = new Language();
        language.contextTypeRegistry = registry;
        language.templateBodyHighlighter = highlighter;
        language.helper = helper;
        language.partialContentAssistContextFactory = partialContentAssistContextFactory;
        language.primaryFileExtension = primaryFileExtension;
        this.registeredLanguages.put(grammar.getName(), language);
    }

    public TemplateBodyHighlighter getTemplateBodyHighlighter(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return (TemplateBodyHighlighter)language.templateBodyHighlighter.get();
    }

    public PartialContentAssistContextFactory getPartialContentAssistContextFactory(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return (PartialContentAssistContextFactory)((Object)language.partialContentAssistContextFactory.get());
    }

    public ContextTypeRegistry getContextTypeRegistry(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return language.contextTypeRegistry;
    }

    public ContextTypeIdHelper getContextTypeIdHelper(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return language.helper;
    }

    public XtextResource createTemporaryResourceIn(Grammar grammar, ResourceSet resourceSet) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        XtextResource syntheticResource = (XtextResource)resourceSet.createResource(URI.createURI((String)("syntethic:/unnamed." + language.primaryFileExtension)));
        return syntheticResource;
    }

    protected static class Language {
        private Provider<TemplateBodyHighlighter> templateBodyHighlighter;
        private ContextTypeRegistry contextTypeRegistry;
        private ContextTypeIdHelper helper;
        private Provider<PartialContentAssistContextFactory> partialContentAssistContextFactory;
        private String primaryFileExtension;

        protected Language() {
        }
    }
}

