/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newproject;

import java.util.ArrayList;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.natures.AcceleoToggleNatureAction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

public class AcceleoConvertProjectWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private WizardNewProjectReferencePage projectReferencesPage;

    public AcceleoConvertProjectWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoConvertProjectWizard.Title"));
    }

    public WizardNewProjectReferencePage getProjectReferencesPage() {
        return this.projectReferencesPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection aSelection) {
        this.selection = aSelection;
    }

    public void addPages() {
        ImageDescriptor wizardImage = AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif");
        this.projectReferencesPage = new WizardNewProjectReferencePage(AcceleoUIMessages.getString("AcceleoConvertProjectWizard.Reference.Name"));
        this.projectReferencesPage.setDescription(AcceleoUIMessages.getString("AcceleoConvertProjectWizard.Reference.Description"));
        this.projectReferencesPage.setImageDescriptor(wizardImage);
        this.addPage((IWizardPage)this.projectReferencesPage);
    }

    private IProject getSelectedProject() {
        IStructuredSelection aSelection;
        IProject selectedProject = null;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (aSelection = (IStructuredSelection)this.selection).size() > 0) {
            Object element = aSelection.getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IProject) {
                selectedProject = (IProject)element;
            } else if (element instanceof IResource) {
                selectedProject = ((IResource)element).getProject();
            }
        }
        return selectedProject;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject != null && ((Composite)this.projectReferencesPage.getControl()).getChildren().length > 1 && ((Composite)this.projectReferencesPage.getControl()).getChildren()[1] instanceof Table) {
            String selectedProjectName = selectedProject.getName();
            Table table = (Table)((Composite)this.projectReferencesPage.getControl()).getChildren()[1];
            TableItem[] children = table.getItems();
            int i = 0;
            while (i < children.length) {
                String dataName;
                TableItem item = children[i];
                Object data = item.getData();
                if (data instanceof IProject && selectedProjectName.equals(dataName = ((IProject)data).getName())) {
                    item.setChecked(true);
                }
                ++i;
            }
        }
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ArrayList<IProject> newProjects = new ArrayList<IProject>();
                IProject[] projects = AcceleoConvertProjectWizard.this.projectReferencesPage.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject iProject = projects[i];
                    if (iProject.getNature("org.eclipse.acceleo.ide.ui.acceleoNature") == null) {
                        newProjects.add(iProject);
                    }
                    ++i;
                }
                AcceleoToggleNatureAction action = new AcceleoToggleNatureAction();
                action.setSelection((ISelection)new StructuredSelection(newProjects));
                try {
                    ExecutionEvent event = new ExecutionEvent();
                    action.execute(event);
                }
                catch (ExecutionException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }
}

