/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.interpreter;

import java.util.ArrayList;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoSourceViewer;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.LinkWithEditorContextAction;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterView;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;

public class LoadModuleAction
extends Action {
    private AcceleoSourceViewer acceleoSource;
    private InterpreterView interpreterView;
    private IToolBarManager toolBarManager;

    public LoadModuleAction(AcceleoSourceViewer source, InterpreterView interpreterView, IToolBarManager toolBarManager) {
        super(null, 2);
        this.acceleoSource = source;
        this.interpreterView = interpreterView;
        this.toolBarManager = toolBarManager;
    }

    public ImageDescriptor getImageDescriptor() {
        return AcceleoUIActivator.getImageDescriptor("icons/interpreter/load_module.gif");
    }

    public String getToolTipText() {
        return AcceleoUIMessages.getString("acceleo.interpreter.load.module");
    }

    public void run() {
        if (this.isChecked()) {
            IContributionItem contributionItem;
            IContributionItem[] items = this.toolBarManager.getItems();
            if (items.length > 0 && (contributionItem = items[0]) instanceof ActionContributionItem && ((ActionContributionItem)contributionItem).getAction() instanceof LinkWithEditorContextAction) {
                ((ActionContributionItem)contributionItem).getAction().setChecked(false);
            }
            ViewerFilter viewerFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof IFile) || "mtl".equals(((IFile)element).getFileExtension());
                }
            };
            ArrayList<1> viewerFilters = new ArrayList<1>();
            viewerFilters.add(viewerFilter);
            IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.acceleoSource.getControl().getShell(), (String)AcceleoUIMessages.getString("acceleo.interpreter.load.module.path.title"), (String)AcceleoUIMessages.getString("acceleo.interpreter.load.module.path"), (boolean)false, null, viewerFilters);
            if (files.length > 0) {
                this.acceleoSource.setModuleImport(files[0]);
                this.acceleoSource.updateCST(this.interpreterView.getInterpreterContext());
            }
        } else {
            this.acceleoSource.setModuleImport(null);
            this.acceleoSource.updateCST(this.interpreterView.getInterpreterContext());
        }
    }

    public void dispose() {
        this.acceleoSource = null;
        this.interpreterView = null;
        this.toolBarManager = null;
    }
}

