/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoPositionedVariable {
    private Variable fVariable;
    private List<Match> fMatches;
    private Match fDefinitionMatch;

    public AcceleoPositionedVariable(Variable variable, AcceleoEditor editor) {
        this.fVariable = variable;
        this.fMatches = new ArrayList<Match>();
        this.findAllPositionedVariables(editor);
    }

    public AcceleoPositionedVariable(VariableExp variableExp, AcceleoEditor editor) {
        this.fVariable = (Variable)variableExp.getReferredVariable();
        this.fMatches = new ArrayList<Match>();
        this.findAllPositionedVariables(editor);
    }

    public Variable getVariable() {
        return this.fVariable;
    }

    public String getVariableName() {
        return this.fVariable.getName();
    }

    public void setVariableMatches(List<Match> matches) {
        this.fMatches = matches;
    }

    public List<Match> getVariableMatches() {
        return this.fMatches;
    }

    public void setVariableDefinitionMatch(Match match) {
        this.fDefinitionMatch = match;
    }

    public Match getVariableDefinitionMatch() {
        return this.fDefinitionMatch;
    }

    private void findAllPositionedVariables(AcceleoEditor editor) {
        ArrayList<Match> list = new ArrayList<Match>();
        ReferencesSearchQuery searchQuery = new ReferencesSearchQuery(editor, (EObject)this.fVariable, false);
        searchQuery.run((IProgressMonitor)new NullProgressMonitor());
        ReferencesSearchResult result = (ReferencesSearchResult)searchQuery.getSearchResult();
        Object[] array = result.getElements();
        int i = 0;
        while (i < array.length) {
            if (((ReferenceEntry)array[i]).getRegion() != null) {
                list.add(new Match(array[i], ((ReferenceEntry)array[i]).getRegion().getOffset(), ((ReferenceEntry)array[i]).getRegion().getLength()));
            }
            ++i;
        }
        this.setVariableMatches(list);
        for (Match match : list) {
            if (match.getLength() <= this.fVariable.getName().length()) continue;
            this.setVariableDefinitionMatch(match);
        }
    }
}

