/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ui.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.common.ui.internal.notification.ColorCache;
import org.eclipse.acceleo.common.ui.internal.notification.FontCache;
import org.eclipse.acceleo.common.ui.notification.NotificationType;
import org.eclipse.acceleo.common.ui.notification.NotificationUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class NotificationDialogUtil {
    private static final int DISPLAY_TIME = 4500;
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 225;
    private static Color titleFgColor;
    private static Color fgColor;
    private static Color bgFgGradient;
    private static Color bgBgGradient;
    private static Color borderColor;
    private static List<Shell> activeShells;
    private static Image oldImage;
    private static Shell shell;

    static {
        activeShells = new ArrayList<Shell>();
    }

    private NotificationDialogUtil() {
    }

    public static void notify(String title, String message, NotificationType type) {
        NotificationDialogUtil.notify(title, message, type, null, NotificationUtils.getDefaultPreferences());
    }

    public static void notify(String title, String message, NotificationType type, SelectionListener hyperlinkListener, IEclipsePreferences preferences) {
        NotificationDialogUtil.initColor(preferences);
        shell = new Shell(Display.getDefault().getActiveShell(), 524296);
        if (!shell.isDisposed()) {
            shell.setLayout((Layout)new FillLayout());
            shell.setForeground(fgColor);
            shell.setBackgroundMode(1);
            shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    activeShells.remove(shell);
                }
            });
        }
        Composite inner = new Composite((Composite)shell, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginLeft = 5;
        gl.marginTop = 0;
        gl.marginRight = 5;
        gl.marginBottom = 5;
        inner.setLayout((Layout)gl);
        if (!shell.isDisposed()) {
            shell.addListener(11, new Listener(){

                public void handleEvent(Event e) {
                    NotificationDialogUtil.handleEventDelegate();
                }
            });
        }
        if (shell.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)shell);
        String[] lines = message.split("\n");
        Point longest = null;
        int typicalHeight = gc.stringExtent((String)"W").y;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Point extent = gc.stringExtent(line);
            if (longest == null) {
                longest = extent;
            } else if (extent.x > longest.x) {
                longest = extent;
            }
            ++n2;
        }
        gc.dispose();
        if (longest.y != typicalHeight) {
            typicalHeight = longest.y;
        }
        int minHeight = typicalHeight * lines.length + 60;
        CLabel imgLabel = new CLabel(inner, 0);
        imgLabel.setLayoutData((Object)new GridData(34));
        imgLabel.setImage(type.getImage());
        CLabel titleLabel = new CLabel(inner, 0);
        titleLabel.setLayoutData((Object)new GridData(772));
        titleLabel.setText(title);
        titleLabel.setForeground(titleFgColor);
        Font f = titleLabel.getFont();
        FontData fd = f.getFontData()[0];
        fd.setStyle(1);
        fd.height = 10.0f;
        titleLabel.setFont(FontCache.getFont(fd));
        Link text = new Link(inner, 64);
        Font tf = text.getFont();
        FontData tfd = tf.getFontData()[0];
        tfd.setStyle(1);
        text.setFont(FontCache.getFont(tfd));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.setForeground(fgColor);
        text.setText(message);
        if (hyperlinkListener != null) {
            text.addSelectionListener(hyperlinkListener);
        }
        if (!shell.isDisposed()) {
            shell.setSize(NotificationUtils.getNotificationWidth(preferences), minHeight);
        }
        NotificationDialogUtil.fadeInAndOut(preferences, minHeight);
    }

    private static void fadeInAndOut(IEclipsePreferences preferences, int minHeight) {
        if (Display.getDefault().getActiveShell() == null || Display.getDefault().getActiveShell().getMonitor() == null) {
            return;
        }
        Rectangle clientArea = Display.getDefault().getActiveShell().getMonitor().getClientArea();
        int startX = clientArea.x + clientArea.width - (NotificationUtils.getNotificationWidth(preferences) + 2);
        int startY = clientArea.y + clientArea.height - (minHeight + 2);
        if (!activeShells.isEmpty()) {
            ArrayList<Shell> modifiable = new ArrayList<Shell>(activeShells);
            Collections.reverse(modifiable);
            for (Shell activeShell : modifiable) {
                if (activeShell.isDisposed()) continue;
                Point curLoc = activeShell.getLocation();
                activeShell.setLocation(curLoc.x, curLoc.y - minHeight);
                if (curLoc.y - minHeight >= 0) continue;
                activeShells.remove(activeShell);
                activeShell.dispose();
            }
        }
        if (!shell.isDisposed()) {
            shell.setLocation(startX, startY);
            shell.setAlpha(0);
            shell.setVisible(true);
            activeShells.add(shell);
            NotificationDialogUtil.fadeIn(shell, preferences);
        }
    }

    private static void initColor(IEclipsePreferences preferences) {
        titleFgColor = ColorCache.getColorFromRGB(NotificationUtils.getNotificationTitleColor(preferences));
        bgFgGradient = ColorCache.getColorFromRGB(NotificationUtils.getNotificationBackgroundTopColor(preferences));
        bgBgGradient = ColorCache.getColorFromRGB(NotificationUtils.getNotificationBackgroundBottomColor(preferences));
        borderColor = ColorCache.getColorFromRGB(NotificationUtils.getNotificationBorderColor(preferences));
        fgColor = ColorCache.getColorFromRGB(NotificationUtils.getNotificationMessageColor(preferences));
    }

    private static void handleEventDelegate() {
        Rectangle rect = shell.getClientArea();
        Image newImage = new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height);
        GC gc = new GC((Drawable)newImage);
        gc.setForeground(bgFgGradient);
        gc.setBackground(bgBgGradient);
        gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        gc.setLineWidth(2);
        gc.setForeground(borderColor);
        gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        gc.dispose();
        shell.setBackgroundImage(newImage);
        if (oldImage != null) {
            oldImage.dispose();
        }
        oldImage = newImage;
    }

    private static void fadeIn(final Shell aShell, final IEclipsePreferences preferences) {
        Runnable run = new Runnable(){

            public void run() {
                if (aShell == null || aShell.isDisposed()) {
                    return;
                }
                int cur = aShell.getAlpha();
                if ((cur += 30) > 225) {
                    aShell.setAlpha(225);
                    if (NotificationUtils.getNotificationFadeOutAuto(preferences)) {
                        NotificationDialogUtil.startTimer(aShell, preferences);
                    }
                    return;
                }
                aShell.setAlpha(cur);
                Display.getDefault().timerExec(50, (Runnable)this);
            }
        };
        Display.getDefault().timerExec(50, run);
    }

    private static void startTimer(final Shell aShell, final IEclipsePreferences preferences) {
        Runnable run = new Runnable(){

            public void run() {
                if (aShell == null || aShell.isDisposed()) {
                    return;
                }
                NotificationDialogUtil.fadeOut(aShell, preferences);
            }
        };
        Display.getDefault().timerExec(4500, run);
    }

    private static void fadeOut(Shell aShell, final IEclipsePreferences preferences) {
        Runnable run = new Runnable(aShell){
            private int cur;
            {
                this.cur = shell.getAlpha();
            }

            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                this.cur -= 8;
                if (this.cur <= 0) {
                    shell.setAlpha(0);
                    if (oldImage != null) {
                        oldImage.dispose();
                    }
                    shell.dispose();
                    activeShells.remove(shell);
                    return;
                }
                shell.setAlpha(this.cur);
                Display.getDefault().timerExec(NotificationUtils.getNotificationFadeOutTimer(preferences), (Runnable)this);
            }
        };
        Display.getDefault().timerExec(NotificationUtils.getNotificationFadeOutTimer(preferences), run);
    }
}

