/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.compatibility.model.mt.MtFactory;
import org.eclipse.acceleo.compatibility.model.mt.ResourceSet;
import org.eclipse.acceleo.compatibility.model.mt.core.CoreFactory;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core.TemplateParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectParser {
    private ProjectParser() {
    }

    public static ResourceSet createModel(IProject[] projects, List<TemplateSyntaxException> problems) throws CoreException {
        ResourceSet root = MtFactory.eINSTANCE.createResourceSet();
        int i = 0;
        while (i < projects.length) {
            AcceleoWorkspaceUtil.INSTANCE.addWorkspaceContribution(projects[i]);
            ++i;
        }
        try {
            Map<IFile, Template> files = ProjectParser.createTemplates(projects, root);
            for (Map.Entry<IFile, Template> entry : files.entrySet()) {
                IFile file = entry.getKey();
                Template template = entry.getValue();
                TemplateParser.parseTemplate(file, template, root, problems);
            }
        }
        finally {
            AcceleoWorkspaceUtil.INSTANCE.reset();
        }
        return root;
    }

    private static Map<IFile, Template> createTemplates(IProject[] projects, ResourceSet root) throws CoreException {
        HashMap<IFile, Template> files = new HashMap<IFile, Template>();
        CompactHashSet done = new CompactHashSet();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int j = 0;
            while (j < entries.length) {
                IFolder inputFolder;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 1 && !done.contains(inputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(entry.getPath())) && inputFolder.exists()) {
                    done.add(inputFolder);
                    ProjectParser.createTemplates(files, inputFolder.getFullPath(), (IContainer)inputFolder, root);
                }
                ++j;
            }
            ++i;
        }
        return files;
    }

    private static void createTemplates(Map<IFile, Template> files, IPath inputFolder, IContainer container, ResourceSet root) throws CoreException {
        IResource[] children = container.members();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mt".equals(((IFile)resource).getFileExtension())) {
                    String[] segments = ((IFile)resource).getFullPath().removeFileExtension().removeFirstSegments(inputFolder.segmentCount()).segments();
                    StringBuffer qualifiedName = new StringBuffer();
                    int j = 0;
                    while (j < segments.length) {
                        if (j > 0) {
                            qualifiedName.append(".");
                        }
                        qualifiedName.append(segments[j]);
                        ++j;
                    }
                    Template template = CoreFactory.eINSTANCE.createTemplate();
                    root.getResources().add((Object)template);
                    template.setName(qualifiedName.toString());
                    files.put((IFile)resource, template);
                } else if (resource instanceof IContainer) {
                    ProjectParser.createTemplates(files, inputFolder, (IContainer)resource, root);
                }
                ++i;
            }
        }
    }
}

