/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.interpreter;

import java.util.concurrent.Callable;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoPartitionScanner;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoCompilationTask;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoEvaluationTask;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoInterpreterConfiguration;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoSourceViewer;
import org.eclipse.acceleo.internal.ide.ui.interpreter.SaveExpressionAction;
import org.eclipse.acceleo.ui.interpreter.internal.SWTUtil;
import org.eclipse.acceleo.ui.interpreter.language.AbstractLanguageInterpreter;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoInterpreter
extends AbstractLanguageInterpreter {
    private AcceleoSourceViewer acceleoSource;
    private SaveExpressionAction saveExpressionAction;

    public void addToolBarActions(InterpreterView interpreterView, IToolBarManager toolBarManager) {
        super.addToolBarActions(interpreterView, toolBarManager);
        this.saveExpressionAction = new SaveExpressionAction(this.acceleoSource, interpreterView);
        toolBarManager.add((IAction)this.saveExpressionAction);
    }

    public boolean canLinkWithEditor(IEditorPart editorPart) {
        return editorPart instanceof AcceleoEditor;
    }

    public void configureSourceViewer(final SourceViewer viewer) {
        if (viewer instanceof AcceleoSourceViewer) {
            Document document = new Document();
            viewer.setDocument((IDocument)document);
            ((AcceleoSourceViewer)viewer).initializeContent();
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new AcceleoPartitionScanner(), AcceleoPartitionScanner.LEGAL_CONTENT_TYPES);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            partitioner.connect((IDocument)document);
            document.addPositionUpdater(new IPositionUpdater(){

                public void update(DocumentEvent event) {
                    ((AcceleoSourceViewer)viewer).handlePositionUpdate(event.getOffset(), event.getOffset() + event.getLength(), event.getText());
                }
            });
            viewer.configure((SourceViewerConfiguration)new AcceleoInterpreterConfiguration(AcceleoUIActivator.getDefault().getPreferenceStore()));
        }
    }

    public SourceViewer createSourceViewer(Composite parent) {
        this.acceleoSource = new AcceleoSourceViewer(parent, null, 2816);
        SWTUtil.setUpScrollableListener((Scrollable)this.acceleoSource.getTextWidget());
        return this.acceleoSource;
    }

    public void dispose() {
        this.acceleoSource = null;
        this.saveExpressionAction.dispose();
    }

    public Callable<CompilationResult> getCompilationTask(InterpreterContext context) {
        return new AcceleoCompilationTask(this.acceleoSource, context);
    }

    public Callable<EvaluationResult> getEvaluationTask(EvaluationContext context) {
        return new AcceleoEvaluationTask(context);
    }

    public void linkWithEditor(IEditorPart editorPart) {
        if (editorPart instanceof AcceleoEditor && this.saveExpressionAction != null) {
            this.saveExpressionAction.setCurrentEditor((AcceleoEditor)editorPart);
            IEditorInput input = editorPart.getEditorInput();
            IFile file = (IFile)Platform.getAdapterManager().getAdapter((Object)input, IFile.class);
            if (file != null && "mtl".equals(file.getFileExtension())) {
                this.acceleoSource.setModuleImport(file);
            }
        } else if (this.saveExpressionAction != null) {
            this.saveExpressionAction.setCurrentEditor(null);
            this.acceleoSource.setModuleImport(null);
        }
    }
}

