/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.debug;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.utilities.ASTNode;

public class ASTFragment {
    private static final String SEPARATOR = "|";
    private static final String ALL_NAMES_FILTER = "*";
    private final ASTNode astNode;
    private String fileShortName;
    private String fragmentURI;
    private boolean empty;
    private String eObjectNameFilter;

    public ASTFragment(ASTNode astNode) {
        this.astNode = astNode;
        if (astNode == null) {
            this.fileShortName = "";
            this.fragmentURI = "";
            this.empty = true;
        } else if (astNode.eResource() != null) {
            this.fileShortName = astNode.eResource().getURI().trimFileExtension().lastSegment();
            this.fragmentURI = astNode.eResource().getURIFragment((EObject)astNode);
            this.empty = false;
        } else {
            this.fileShortName = "";
            this.fragmentURI = EcoreUtil.getURI((EObject)astNode).toString();
            this.empty = this.fragmentURI.length() == 0;
        }
        this.eObjectNameFilter = "";
    }

    public ASTFragment(String string) {
        this.astNode = null;
        if (string == null) {
            this.fileShortName = "";
            this.fragmentURI = "";
            this.empty = true;
            this.eObjectNameFilter = "";
        } else {
            int i = string.indexOf(SEPARATOR);
            if (i > -1) {
                this.fileShortName = string.substring(0, i);
                int j = string.indexOf(SEPARATOR, i + SEPARATOR.length());
                if (j > -1) {
                    this.eObjectNameFilter = string.substring(j + SEPARATOR.length());
                } else {
                    j = string.length();
                    this.eObjectNameFilter = "";
                }
                this.fragmentURI = string.substring(i + SEPARATOR.length(), j);
                this.empty = this.fileShortName.length() == 0 && this.fragmentURI.length() == 0;
            } else {
                this.fileShortName = "";
                this.fragmentURI = string;
                this.empty = this.fragmentURI.length() == 0;
                this.eObjectNameFilter = "";
            }
        }
    }

    public ASTNode getASTNode() {
        return this.astNode;
    }

    public String getEObjectNameFilter() {
        return this.eObjectNameFilter;
    }

    public void setEObjectNameFilter(String nameFilter) {
        this.eObjectNameFilter = nameFilter;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int hashCode() {
        return (String.valueOf(this.fileShortName) + this.fragmentURI).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ASTFragment) {
            ASTFragment other = (ASTFragment)obj;
            boolean result = this.fileShortName.equals(other.fileShortName) && this.fragmentURI.equals(other.fragmentURI) ? ("".equals(this.eObjectNameFilter) || "".equals(other.eObjectNameFilter) || ALL_NAMES_FILTER.equals(this.eObjectNameFilter) || ALL_NAMES_FILTER.equals(other.eObjectNameFilter) ? true : (this.eObjectNameFilter.startsWith(ALL_NAMES_FILTER) && other.eObjectNameFilter.endsWith(this.eObjectNameFilter.substring(ALL_NAMES_FILTER.length())) ? true : (other.eObjectNameFilter.startsWith(ALL_NAMES_FILTER) && this.eObjectNameFilter.endsWith(other.eObjectNameFilter.substring(ALL_NAMES_FILTER.length())) ? true : (this.eObjectNameFilter.endsWith(ALL_NAMES_FILTER) && other.eObjectNameFilter.startsWith(this.eObjectNameFilter.substring(0, this.eObjectNameFilter.length() - ALL_NAMES_FILTER.length())) ? true : (other.eObjectNameFilter.endsWith(ALL_NAMES_FILTER) && this.eObjectNameFilter.startsWith(other.eObjectNameFilter.substring(0, other.eObjectNameFilter.length() - ALL_NAMES_FILTER.length())) ? true : this.eObjectNameFilter.equals(other.eObjectNameFilter)))))) : false;
            return result;
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.empty) {
            return "";
        }
        return String.valueOf(this.fileShortName) + SEPARATOR + this.fragmentURI + SEPARATOR + this.eObjectNameFilter;
    }
}

