/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.ast.ocl.environment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironment;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoTypeResolver;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.AbstractTypeChecker;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEnvironmentGalileo
extends AcceleoEnvironment {
    private AcceleoTypeChecker typeChecker;

    public AcceleoEnvironmentGalileo(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super(parent);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, Boolean.TRUE);
    }

    public AcceleoEnvironmentGalileo(Resource oclEnvironmentResource) {
        super(oclEnvironmentResource);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, Boolean.TRUE);
    }

    public TypeChecker<EClassifier, EOperation, EStructuralFeature> createTypeChecker() {
        if (this.typeChecker == null) {
            this.typeChecker = new AcceleoTypeChecker((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this);
        }
        return this.typeChecker;
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver() {
        return new AcceleoTypeResolver(null);
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return new AcceleoTypeResolver(this, resource);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.typeChecker.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AcceleoTypeChecker
    extends AbstractTypeChecker<EClassifier, EOperation, EStructuralFeature, EParameter> {
        private final Map<EClassifier, Set<EClassifier>> alteredTypes;
        private final Map<EClassifier, Set<EClassifier>> subTypes;
        private final Map<Long, EStructuralFeature> hierarchyFeatureCache;

        public AcceleoTypeChecker(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> environment) {
            super(environment);
            this.alteredTypes = new HashMap<EClassifier, Set<EClassifier>>();
            this.subTypes = new HashMap<EClassifier, Set<EClassifier>>();
            this.hierarchyFeatureCache = new HashMap<Long, EStructuralFeature>();
        }

        public EClassifier commonSuperType(Object problemObject, EClassifier type1, EClassifier type2) {
            EClassifier oclType1 = null;
            EClassifier oclType2 = null;
            if (type1 != null) {
                oclType1 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type1);
            }
            if (type2 != null) {
                oclType2 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type2);
            }
            EClassifier commonSuperType = oclType1 == this.getEnvironment().getOCLStandardLibrary().getOclAny() ? oclType1 : (oclType2 == this.getEnvironment().getOCLStandardLibrary().getOclAny() ? oclType2 : (oclType1 instanceof org.eclipse.ocl.types.CollectionType && !(oclType2 instanceof org.eclipse.ocl.types.CollectionType) ? (EClassifier)this.getEnvironment().getOCLStandardLibrary().getOclAny() : (oclType2 instanceof org.eclipse.ocl.types.CollectionType && !(oclType1 instanceof org.eclipse.ocl.types.CollectionType) ? (EClassifier)this.getEnvironment().getOCLStandardLibrary().getOclAny() : (EClassifier)super.commonSuperType(problemObject, (Object)type1, (Object)type2))));
            return commonSuperType;
        }

        public List<EOperation> getOperations(EClassifier owner) {
            ArrayList<EOperation> result = new ArrayList<EOperation>(super.getOperations((Object)owner));
            if (!(owner instanceof PrimitiveType)) {
                result.addAll(this.getUMLReflection().getOperations((Object)EcorePackage.eINSTANCE.getEObject()));
            }
            return result;
        }

        public int getRelationship(EClassifier type1, EClassifier type2) {
            int relationship;
            EClassifier oclType1 = null;
            EClassifier oclType2 = null;
            if (type1 != null) {
                oclType1 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type1);
            }
            if (type2 != null) {
                oclType2 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type2);
            }
            if ((relationship = oclType1 == oclType2 ? 1 : (oclType1 == this.getEnvironment().getOCLStandardLibrary().getOclAny() ? 4 : (oclType2 == this.getEnvironment().getOCLStandardLibrary().getOclAny() ? 2 : super.getRelationship((Object)type1, (Object)type2)))) == 8 && oclType1 != null && oclType2 != null) {
                URI uri1 = EcoreUtil.getURI((EObject)oclType1);
                URI uri2 = EcoreUtil.getURI((EObject)oclType2);
                if (uri1 != null && uri1.equals((Object)uri2)) {
                    relationship = 1;
                }
            }
            return relationship;
        }

        public EClassifier getResultType(Object problemObject, EClassifier owner, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
            EClassifier type = (EClassifier)super.getResultType(problemObject, (Object)owner, (Object)operation, args);
            if (args.size() == 0 || operation.getEAnnotation("MTL non-standard") == null) {
                return type;
            }
            String operationName = operation.getName();
            if (args.get(0) instanceof TypeExp) {
                boolean isParameterizedCollection = "eAllContents".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "eContents".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "filter".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "ancestors".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "siblings".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "eInverse".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "precedingSiblings".equals(operationName);
                boolean bl = isParameterizedCollection = isParameterizedCollection || "followingSiblings".equals(operationName);
                if (isParameterizedCollection) {
                    CollectionType alteredSequence = type instanceof SequenceType || type instanceof OrderedSetType || type instanceof BagType || type instanceof SetType ? (CollectionType)EcoreUtil.copy((EObject)type) : (owner instanceof CollectionType ? (CollectionType)EcoreUtil.copy((EObject)owner) : (CollectionType)EcoreUtil.copy((EObject)type));
                    alteredSequence.setElementType((Object)((EClassifier)((TypeExp)args.get(0)).getReferredType()));
                    CompactHashSet altered = this.alteredTypes.get(type);
                    if (altered == null) {
                        altered = new CompactHashSet();
                        this.alteredTypes.put(type, (Set<EClassifier>)altered);
                    }
                    altered.add((EClassifier)alteredSequence);
                    type = alteredSequence;
                } else if ("current".equals(operationName) || "eContainer".equals(operationName)) {
                    type = (EClassifier)((TypeExp)args.get(0)).getReferredType();
                }
            } else if (args.get(0) instanceof StringLiteralExp && "eGet".equals(operationName)) {
                String featureName = ((StringLiteralExp)args.get(0)).getStringSymbol();
                EStructuralFeature feature = null;
                if (owner instanceof EClass) {
                    for (EStructuralFeature childFeature : ((EClass)owner).getEAllStructuralFeatures()) {
                        if (!childFeature.getName().equals(featureName)) continue;
                        feature = childFeature;
                        break;
                    }
                }
                if (feature == null) {
                    this.createSubTypesHierarchy(owner);
                    feature = this.findFeatureInSubTypesHierarchy(owner, featureName);
                }
                if (feature != null) {
                    type = this.inferTypeFromFeature(feature);
                    Long key = owner.hashCode() + featureName.hashCode();
                    if (!this.hierarchyFeatureCache.containsKey(key)) {
                        this.hierarchyFeatureCache.put(key, feature);
                    }
                }
            }
            return type;
        }

        protected void dispose() {
            for (Set<EClassifier> alteredTypesValuesSet : this.alteredTypes.values()) {
                alteredTypesValuesSet.clear();
            }
            for (Set<EClassifier> subTypesValuesSet : this.subTypes.values()) {
                subTypesValuesSet.clear();
            }
            this.alteredTypes.clear();
            this.subTypes.clear();
            this.hierarchyFeatureCache.clear();
        }

        private EStructuralFeature findFeatureInType(EClassifier type, String featureName) {
            Long key = type.hashCode() + featureName.hashCode();
            if (this.hierarchyFeatureCache.containsKey(key)) {
                return this.hierarchyFeatureCache.get(key);
            }
            EStructuralFeature feature = null;
            for (EObject child : type.eContents()) {
                if (!(child instanceof EStructuralFeature) || !((EStructuralFeature)child).getName().equals(featureName)) continue;
                feature = (EStructuralFeature)child;
                this.hierarchyFeatureCache.put(key, feature);
                break;
            }
            return feature;
        }

        private EStructuralFeature findFeatureInSubTypesHierarchy(EClassifier base, String featureName) {
            EStructuralFeature feature = null;
            for (EClassifier subType : this.subTypes.get(base)) {
                feature = this.findFeatureInType(subType, featureName);
                if (feature == null) {
                    feature = this.findFeatureInSubTypesHierarchy(subType, featureName);
                }
                if (feature != null) break;
            }
            return feature;
        }

        private EClassifier inferTypeFromFeature(EStructuralFeature feature) {
            Object type = feature.getEType();
            if (feature.isMany()) {
                type = feature.isOrdered() && feature.isUnique() ? EcoreFactory.eINSTANCE.createOrderedSetType() : (feature.isOrdered() && !feature.isUnique() ? EcoreFactory.eINSTANCE.createSequenceType() : (!feature.isOrdered() && feature.isUnique() ? EcoreFactory.eINSTANCE.createSetType() : EcoreFactory.eINSTANCE.createBagType()));
                ((org.eclipse.ocl.types.CollectionType)type).setElementType((Object)feature.getEType());
            }
            return type;
        }

        private void createSubTypesHierarchy(EClassifier classifier) {
            if (this.subTypes.get(classifier) == null) {
                CompactHashSet hierarchy = new CompactHashSet();
                ECrossReferenceAdapter referencer = this.getCrossReferencer((EObject)classifier);
                for (EStructuralFeature.Setting setting : referencer.getInverseReferences((EObject)classifier, false)) {
                    if (setting.getEStructuralFeature() != EcorePackage.eINSTANCE.getEClass_ESuperTypes()) continue;
                    EClassifier subType = (EClassifier)setting.getEObject();
                    hierarchy.add(subType);
                    this.createSubTypesHierarchy(subType);
                }
                this.subTypes.put(classifier, (Set<EClassifier>)hierarchy);
            }
        }

        public boolean exactTypeMatch(EClassifier type1, EClassifier type2) {
            boolean match = false;
            Set<EClassifier> alteredType1 = this.alteredTypes.get(type1);
            Set<EClassifier> alteredType2 = this.alteredTypes.get(type2);
            if (alteredType1 != null) {
                for (EClassifier alteredType : alteredType1) {
                    if (alteredType != type2) continue;
                    match = true;
                    break;
                }
            }
            if (!match && alteredType2 != null) {
                for (EClassifier alteredType : alteredType2) {
                    if (alteredType != type1) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                return super.exactTypeMatch((Object)type1, (Object)type2);
            }
            return true;
        }

        protected EClassifier resolve(EClassifier type) {
            return (EClassifier)this.getEnvironment().getTypeResolver().resolve((Object)type);
        }

        protected org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> resolveCollectionType(CollectionKind kind, EClassifier elementType) {
            return this.getEnvironment().getTypeResolver().resolveCollectionType(kind, (Object)elementType);
        }

        protected TupleType<EOperation, EStructuralFeature> resolveTupleType(EList<? extends TypedElement<EClassifier>> parts) {
            return this.getEnvironment().getTypeResolver().resolveTupleType(parts);
        }

        private ECrossReferenceAdapter getCrossReferencer(EObject scope) {
            ECrossReferenceAdapter referencer = null;
            for (Adapter adapter : scope.eResource().eAdapters()) {
                if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                referencer = (ECrossReferenceAdapter)adapter;
                break;
            }
            if (referencer == null) {
                referencer = new ECrossReferenceAdapter();
                scope.eResource().eAdapters().add((Object)referencer);
            }
            return referencer;
        }
    }
}

