/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.launching;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoJavaArgumentsTab;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoMainTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class AcceleoPropertiesFilesTab
extends AbstractLaunchConfigurationTab {
    private Text argumentsText;

    public void createControl(Composite parent) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(1, false));
        g.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        g.setLayoutData((Object)gd);
        ((GridLayout)g.getLayout()).verticalSpacing = 0;
        this.createAcceleoArgumentsEditor(g);
        this.setControl((Control)g);
    }

    protected void createAcceleoArgumentsEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoPropertiesFilesTab.Arguments"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.argumentsText = new Text(comp, 2626);
        GridData gd = new GridData(1808);
        int heightHint = 150;
        gd.heightHint = 150;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        this.argumentsText.setLayoutData((Object)gd);
        this.argumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoPropertiesFilesTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createHelpButton(comp, AcceleoUIMessages.getString("AcceleoPropertiesFilesTab.Help.Properties"));
    }

    private ToolBar createHelpButton(Composite parent, String helpMessage) {
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        result.setLayoutData((Object)new GridData(66));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
        return result;
    }

    private Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateAcceleoArgumentsFromConfig(configuration);
    }

    protected void updateAcceleoArgumentsFromConfig(ILaunchConfiguration config) {
        String args = "";
        try {
            args = config.getAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.argumentsText.setText(args);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ILaunchConfigurationTab[] tabs;
        configuration.setAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", this.argumentsText.getText());
        AcceleoJavaArgumentsTab argumentTab = null;
        AcceleoMainTab mainTab = null;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = this.getLaunchConfigurationDialog().getTabs();
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab iLaunchConfigurationTab = iLaunchConfigurationTabArray[n2];
            if (iLaunchConfigurationTab instanceof AcceleoJavaArgumentsTab) {
                argumentTab = (AcceleoJavaArgumentsTab)iLaunchConfigurationTab;
            } else if (iLaunchConfigurationTab instanceof AcceleoMainTab) {
                mainTab = (AcceleoMainTab)iLaunchConfigurationTab;
            }
            ++n2;
        }
        if (argumentTab != null && mainTab != null) {
            argumentTab.updateArguments(configuration, mainTab.getModel().trim(), mainTab.getTarget().trim(), this.argumentsText.getText());
        }
    }

    public String getName() {
        return AcceleoUIMessages.getString("AcceleoPropertiesFilesTab.Name");
    }

    public String getPropertiesFiles() {
        return this.argumentsText.getText();
    }
}

