/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.AcceleoUIDocumentationUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoHover
implements IAnnotationHover,
ITextHover {
    protected AcceleoEditor editor;

    public AcceleoHover(AcceleoEditor editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return this.getHoverText(sourceViewer.getAnnotationModel(), sourceViewer.getDocument(), lineNumber);
    }

    protected String getHoverText(IAnnotationModel model, IDocument document, int lineNumber) {
        StringBuffer text = null;
        for (Annotation annotation : this.findAnnotations(model, document, lineNumber)) {
            MarkerAnnotation markerAnnotation;
            IMarker marker;
            String msg = null;
            if (annotation instanceof MarkerAnnotation && (marker = (markerAnnotation = (MarkerAnnotation)annotation).getMarker()) != null) {
                msg = MarkerUtilities.getMessage((IMarker)marker);
            }
            if (msg == null) continue;
            if (text == null) {
                text = new StringBuffer(msg);
                continue;
            }
            text.append('\n');
            text.append(msg);
        }
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Annotation> findAnnotations(IAnnotationModel model, IDocument document, int lineNumber) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        IAnnotationModel annotationModel = model == null && this.editor != null ? this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput()) : model;
        if (annotationModel != null) {
            Object object = this.getLockObject(annotationModel);
            synchronized (object) {
                Iterator it = annotationModel.getAnnotationIterator();
                while (it.hasNext()) {
                    Annotation annotation = (Annotation)it.next();
                    Position position = annotationModel.getPosition(annotation);
                    try {
                        if (document == null || document.getLineOfOffset(position.offset) != lineNumber) continue;
                        annotations.add(annotation);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
        return annotations;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ASTNode astNode;
        if (hoverRegion != null && this.editor != null && this.editor.getContent() != null && (astNode = this.editor.getContent().getResolvedASTNode(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength())) != null) {
            EObject eObject = OpenDeclarationUtils.findDeclarationFromAST(astNode);
            if (eObject instanceof IteratorExp && this.editor.getContent().getOCLEnvironment() != null) {
                eObject = OpenDeclarationUtils.findIteratorEOperation(this.editor.getContent().getOCLEnvironment(), (IteratorExp)eObject);
            }
            if (eObject != null) {
                return this.getInfo(eObject);
            }
        }
        return null;
    }

    private String getInfo(EObject eObject) {
        Documentation documentation = null;
        if (eObject instanceof Template) {
            documentation = ((Template)eObject).getDocumentation();
        }
        if (eObject instanceof Module) {
            documentation = ((Module)eObject).getDocumentation();
        }
        if (eObject instanceof Query) {
            documentation = ((Query)eObject).getDocumentation();
        }
        if (eObject instanceof Macro) {
            documentation = ((Macro)eObject).getDocumentation();
        }
        if (documentation != null) {
            return AcceleoUIDocumentationUtils.getTextFrom(documentation);
        }
        return AcceleoUIDocumentationUtils.getSignatureFrom(eObject);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (offset > -1) {
            return new Region(offset, 0);
        }
        return null;
    }
}

