/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import org.eclipse.acceleo.internal.ide.ui.debug.core.ITemplateDebugger;
import org.eclipse.acceleo.internal.ide.ui.debug.core.StackInfo;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AbstractDebugElement;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoDebugTarget;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoStackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class AcceleoThread
extends AbstractDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping;
    private boolean suspended;

    public AcceleoThread(AcceleoDebugTarget target) {
        super(target);
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    protected void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        AcceleoDebugTarget debugTarget = (AcceleoDebugTarget)this.getDebugTarget();
        ITemplateDebugger debugger = debugTarget.getDebugger();
        StackInfo[] stack = debugger.getStack();
        IStackFrame[] ret = new IStackFrame[stack.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new AcceleoStackFrame(this, stack[stack.length - i - 1]);
            ++i;
        }
        return ret;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return "Thread[1]";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        ((AcceleoDebugTarget)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        ((AcceleoDebugTarget)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        ((AcceleoDebugTarget)this.getDebugTarget()).stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }
}

