/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders.prefs;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class AcceleoCompilerPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IAdaptable element;
    private Button strictCompliance;
    private Button xmiResourceButton;
    private Button binaryResourceButton;

    public AcceleoCompilerPage() {
        this.setDescription(AcceleoUIMessages.getString("AcceleoCompilerPage.Description"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if (this.strictCompliance.getSelection()) {
                settings.setCompliance("strict");
            } else {
                settings.setCompliance("pragmatic");
            }
            if (this.xmiResourceButton.getSelection()) {
                settings.setResourceKind("xmi");
            } else {
                settings.setResourceKind("binary");
            }
            try {
                settings.save();
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createComplianceGroup(composite);
        this.createResourceKindGroup(composite);
        return composite;
    }

    private void createComplianceGroup(Composite parent) {
        this.strictCompliance = new Button(parent, 32);
        this.strictCompliance.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.StrictMTLCompliance"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.strictCompliance.setLayoutData((Object)gridData);
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if ("strict" == settings.getCompliance()) {
                this.strictCompliance.setSelection(true);
            } else if ("pragmatic" == settings.getCompliance()) {
                this.strictCompliance.setSelection(false);
            } else {
                this.strictCompliance.setSelection(false);
            }
        } else {
            this.strictCompliance.setSelection(false);
        }
    }

    private void createResourceKindGroup(Composite parent) {
        Group group = new Group(parent, 2048);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.ResourceKind"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.binaryResourceButton = new Button((Composite)group, 16);
        this.binaryResourceButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.BinaryResourceKind"));
        this.binaryResourceButton.setLayoutData((Object)new GridData());
        this.xmiResourceButton = new Button((Composite)group, 16);
        this.xmiResourceButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.XMIResourceKind"));
        this.xmiResourceButton.setLayoutData((Object)new GridData());
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if ("xmi" == settings.getResourceKind()) {
                this.xmiResourceButton.setSelection(true);
                this.binaryResourceButton.setSelection(false);
            } else if ("binary" == settings.getResourceKind()) {
                this.xmiResourceButton.setSelection(false);
                this.binaryResourceButton.setSelection(true);
            } else {
                this.xmiResourceButton.setSelection(false);
                this.binaryResourceButton.setSelection(true);
            }
        } else {
            this.xmiResourceButton.setSelection(false);
            this.binaryResourceButton.setSelection(true);
        }
    }
}

