/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newproject;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardController;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.CreateTemplateData;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.AcceleoNewProjectWizard;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateModuleData {
    private String projectName;
    private String moduleName;
    private List<CreateTemplateData> templates;
    private List<String> pluginDependencies;

    public CreateModuleData(AcceleoNewProjectWizard wizard) {
        this.projectName = wizard.getNewProjectPage().getProjectName();
        this.computeModuleName();
        this.templates = new ArrayList<CreateTemplateData>();
        this.pluginDependencies = new ArrayList<String>();
        this.computeMetamodelDependencies(wizard);
    }

    private void computeModuleName() {
        this.moduleName = this.projectName;
        if (this.moduleName.startsWith("org.eclipse.acceleo.module.")) {
            this.moduleName = this.moduleName.substring("org.eclipse.acceleo.module.".length());
        } else {
            int i = this.moduleName.lastIndexOf(46);
            if (i > -1) {
                this.moduleName = this.moduleName.substring(i + 1);
            }
        }
        if (this.moduleName.length() > 0) {
            StringTokenizer st = new StringTokenizer(this.moduleName, ".");
            this.moduleName = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0) continue;
                this.moduleName = String.valueOf(this.moduleName) + Character.toUpperCase(token.charAt(0)) + token.substring(1);
            }
        }
    }

    private void computeMetamodelDependencies(AcceleoNewProjectWizard wizard) {
        ArrayList<String> metamodelDone = new ArrayList<String>();
        for (AcceleoNewTemplatesWizardController controller : wizard.getTemplatePage().getControllers()) {
            CreateTemplateData data = controller.getModel();
            String metamodelURIs = data.getTemplateMetamodel();
            StringTokenizer st = new StringTokenizer(metamodelURIs, ",");
            while (st.hasMoreTokens()) {
                String metamodelURI = st.nextToken().trim();
                if (metamodelDone.contains(metamodelURI)) continue;
                metamodelDone.add(metamodelURI);
                EPackage metamodel = ModelUtils.getEPackage((String)metamodelURI);
                if (metamodel == null) continue;
                this.computeMetamodelDependencies(metamodel);
            }
        }
    }

    private void computeMetamodelDependencies(EPackage metamodel) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
        if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] members = extension.getConfigurationElements();
                int j = 0;
                while (j < members.length) {
                    IConfigurationElement member = members[j];
                    String mURI = member.getAttribute("uri");
                    if (mURI != null && mURI.equals(metamodel.getNsURI()) && !this.pluginDependencies.contains(member.getNamespaceIdentifier())) {
                        this.pluginDependencies.add(member.getNamespaceIdentifier());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List<CreateTemplateData> getTemplates() {
        return this.templates;
    }

    public List<String> getPluginDependencies() {
        return this.pluginDependencies;
    }
}

