/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.launching;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.launching.strategy.IAcceleoLaunchingStrategy;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoLaunchDelegateStandalone;
import org.eclipse.acceleo.internal.ide.ui.launching.strategy.AcceleoJavaLaunchingStrategy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.Bundle;

public class AcceleoLaunchDelegate
extends AcceleoLaunchDelegateStandalone {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IAcceleoLaunchingStrategy strategy = this.getLaunchingStrategy(configuration);
            if (strategy instanceof AcceleoJavaLaunchingStrategy) {
                super.launch(configuration, mode, launch, monitor);
            } else if (strategy != null) {
                strategy.launch(configuration, mode, launch, monitor);
            }
        }
        finally {
            if (!launch.isTerminated()) {
                launch.terminate();
            }
        }
    }

    private IAcceleoLaunchingStrategy getLaunchingStrategy(ILaunchConfiguration configuration) {
        String description;
        try {
            description = configuration.getAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", "");
        }
        catch (CoreException e) {
            description = "";
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return this.getLaunchingStrategy(description);
    }

    private IAcceleoLaunchingStrategy getLaunchingStrategy(String launchingID) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.acceleo.ide.ui.launching");
        if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] members = extension.getConfigurationElements();
                int j = 0;
                while (j < members.length) {
                    IConfigurationElement member = members[j];
                    String description = member.getAttribute("description");
                    String strategyClass = member.getAttribute("class");
                    if (strategyClass != null && description != null && description.equals(launchingID)) {
                        Status status;
                        try {
                            Bundle bundle = Platform.getBundle((String)member.getNamespaceIdentifier());
                            Class c = bundle.loadClass(strategyClass);
                            return (IAcceleoLaunchingStrategy)c.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                        catch (InstantiationException e) {
                            status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                        catch (IllegalAccessException e) {
                            status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }
}

