/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoPositionedTemplate {
    private static AcceleoPositionedTemplate[] input;
    private static AcceleoEditor acceleoEditor;
    private Template fTemplate;
    private List<Match> fMatches;
    private Match fDefinitionMatch;

    public AcceleoPositionedTemplate(Template template) {
        this.fTemplate = template;
        this.fMatches = new ArrayList<Match>();
    }

    public static void computeCompleteInput() {
        List<AcceleoPositionedTemplate> list = AcceleoPositionedTemplate.findAllPositionedTemplates();
        input = list.toArray(new AcceleoPositionedTemplate[list.size()]);
    }

    public static void computePartialInput(Template template) {
        ArrayList<AcceleoPositionedTemplate> positionedTemplatesList = new ArrayList<AcceleoPositionedTemplate>();
        acceleoEditor.getContent().getResolvedASTNode(0, acceleoEditor.getContent().getText().length());
        Module astModule = acceleoEditor.getContent().getAST();
        EList moduleElementList = astModule.getOwnedModuleElement();
        for (ModuleElement moduleElement : moduleElementList) {
            if (!(moduleElement instanceof Template)) continue;
            positionedTemplatesList.add(new AcceleoPositionedTemplate((Template)moduleElement));
        }
        if (template != null) {
            boolean isInTheList = false;
            for (AcceleoPositionedTemplate acceleoPositionedTemplate : positionedTemplatesList) {
                if (!OpenDeclarationUtils.checkTemplateEqual(acceleoPositionedTemplate.getTemplate(), template)) continue;
                isInTheList = true;
                break;
            }
            if (!isInTheList) {
                positionedTemplatesList.add(new AcceleoPositionedTemplate(template));
            }
        }
        input = positionedTemplatesList.toArray(new AcceleoPositionedTemplate[positionedTemplatesList.size()]);
    }

    public void computeOccurrencesOfTemplate() {
        List<Match> list = OpenDeclarationUtils.findOccurrences(acceleoEditor, (EObject)this.fTemplate);
        this.setTemplateMatches(list);
        for (Match match : list) {
            if (match.getLength() <= this.getTemplate().getName().length()) continue;
            this.setTemplateDefinitionMatch(match);
        }
    }

    public static AcceleoPositionedTemplate[] getInput() {
        return input;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    public String getTemplateName() {
        return this.fTemplate.getName();
    }

    public void setTemplateMatches(List<Match> matches) {
        this.fMatches = matches;
    }

    public List<Match> getTemplateMatches() {
        return this.fMatches;
    }

    public void setTemplateDefinitionMatch(Match match) {
        this.fDefinitionMatch = match;
    }

    public Match getTemplateDefinitionMatch() {
        return this.fDefinitionMatch;
    }

    private static List<AcceleoPositionedTemplate> findAllPositionedTemplates() {
        ArrayList<AcceleoPositionedTemplate> positionedTemplatesList = new ArrayList<AcceleoPositionedTemplate>();
        ArrayList<Template> templateList = new ArrayList<Template>();
        Module astModule = acceleoEditor.getContent().getAST();
        EList moduleElementList = astModule.getOwnedModuleElement();
        for (ModuleElement moduleElement : moduleElementList) {
            if (!(moduleElement instanceof Template)) continue;
            templateList.add((Template)moduleElement);
        }
        for (Template template : templateList) {
            AcceleoPositionedTemplate positionedTemplate = new AcceleoPositionedTemplate(template);
            List<Match> list = OpenDeclarationUtils.findOccurrences(acceleoEditor, (EObject)template);
            positionedTemplate.setTemplateMatches(list);
            for (Match match : list) {
                if (match.getLength() <= template.getName().length()) continue;
                positionedTemplate.setTemplateDefinitionMatch(match);
            }
            positionedTemplatesList.add(positionedTemplate);
        }
        return positionedTemplatesList;
    }

    public static void setAcceleoEditor(AcceleoEditor editor) {
        acceleoEditor = editor;
    }
}

