/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.model.mtl.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCache {
    private static final Object INVALID_QUERY_RESULT = new Object();
    private static final Object NO_CACHED_RESULT = new Object();
    private static final Object NULL_QUERY_RESULT = new Object();
    private final Object invalid;
    private final Map<Query, Map<List<Object>, Object>> queryResults = new HashMap<Query, Map<List<Object>, Object>>();

    public QueryCache(Object invalid) {
        this.invalid = invalid;
    }

    public static boolean isCachedResult(Object result) {
        return result != NO_CACHED_RESULT;
    }

    public static boolean isInvalid(Object result) {
        return result == INVALID_QUERY_RESULT;
    }

    public static boolean isNull(Object result) {
        return result == NULL_QUERY_RESULT;
    }

    public void cacheResult(Query query, List<Object> params, Object result) {
        Map<List<Object>, Object> cache = this.queryResults.get(query);
        if (cache == null) {
            cache = new HashMap<List<Object>, Object>();
            this.queryResults.put(query, cache);
        }
        if (result == this.invalid) {
            cache.put(params, INVALID_QUERY_RESULT);
        } else if (result == null) {
            cache.put(params, NULL_QUERY_RESULT);
        } else {
            cache.put(params, result);
        }
    }

    public Object getResult(Query query, List<Object> params) {
        Map<List<Object>, Object> cache = this.queryResults.get(query);
        if (cache == null) {
            return NO_CACHED_RESULT;
        }
        Object result = cache.get(params);
        if (result == null) {
            result = NO_CACHED_RESULT;
        }
        return result;
    }
}

