/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IDestinationChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.ResourceSourceChooser;

public class ResourceSourceDestChooser
extends ResourceSourceChooser
implements IDestinationChooser {
    private String myFileName;
    private String myDefaultFileName;

    public ResourceSourceDestChooser(ResourceSet rs) {
        super(false, rs);
    }

    protected String getDefaultFileName() {
        return this.myFileName;
    }

    public void setInitialSelection(String uriString) {
        this.myFileName = this.myDefaultFileName;
        URI uri = URI.createURI((String)uriString);
        if (uri == null) {
            return;
        }
        IFile file = WorkspaceUtils.getWorkspaceFile((URI)uri);
        if (file == null) {
            return;
        }
        if (file.exists()) {
            this.myInitialSelection = ResourceSourceDestChooser.createSelectionForUri(uri, file);
        } else {
            this.myInitialSelection = new StructuredSelection((Object)file.getParent());
            this.myFileName = file.getName();
        }
    }

    public void initNewName(String baseName, String extension) {
        this.myDefaultFileName = baseName;
        if (extension.length() > 0) {
            this.myDefaultFileName = String.valueOf(this.myDefaultFileName) + "." + extension;
        }
    }
}

