/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.ui;

import org.eclipse.emf.henshin.diagram.edit.parts.ModuleEditPart;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.variability.mergein.clone.GraphMiningBasedCloneGroupDetector;
import org.eclipse.emf.henshin.variability.ui.views.CloneGroupView;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class StartCloneDetectionAction
implements IActionDelegate {
    public static final String ID = "org.eclipse.emf.henshin.variability.ui.StartCloneDetectionActionID";
    private ModuleEditPart selectedElement;

    public void run(IAction action) {
        if (this.selectedElement.getModel() instanceof DiagramImpl) {
            CloneGroupView cloneGroupView = this.openAndGetCloneGroupView();
            cloneGroupView.showBusy(true);
            Module module = (Module)((DiagramImpl)this.selectedElement.getModel()).getElement();
            GraphMiningBasedCloneGroupDetector cd = new GraphMiningBasedCloneGroupDetector(module.getAllRules(), true);
            cd.detectCloneGroups();
            cloneGroupView.setEditingDomain(this.selectedElement.getEditingDomain());
            cloneGroupView.setContents(cd.getResultOrderedByNumberOfCommonElements());
            cloneGroupView.setContextDiagram(this.selectedElement);
            cloneGroupView.showBusy(false);
        }
    }

    private CloneGroupView openAndGetCloneGroupView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.emf.henshin.variability.ui.views.CloneGroupView");
            return (CloneGroupView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.emf.henshin.variability.ui.views.CloneGroupView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.selectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof ModuleEditPart) {
            this.selectedElement = (ModuleEditPart)structuredSelection.getFirstElement();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

