/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.multithread.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.transaction.multithread.tests.AbstractMultithreadTest;
import org.eclipse.emf.transaction.multithread.tests.Constants;
import org.eclipse.emf.transaction.multithread.tests.NestedWriteThread;
import org.eclipse.emf.transaction.multithread.tests.WriteThread;

public class WriteOperationTest
extends AbstractMultithreadTest {
    public static Test suite() {
        return new TestSuite(WriteOperationTest.class, "Writer Thread Tests");
    }

    public void testWriteOperation() {
        WriteThread writeThread1 = new WriteThread(this.getDomain());
        writeThread1.start();
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (writeThread1.isAlive()) continue;
            done = true;
        }
        WriteOperationTest.assertFalse((boolean)writeThread1.isFailed());
        WriteOperationTest.assertTrue((boolean)writeThread1.isExecuted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimultaneousWrites() {
        Object notifier = new Object();
        WriteThread writeThread1 = new WriteThread(this.getDomain(), null, notifier);
        WriteThread writeThread2 = new WriteThread(this.getDomain(), null, notifier);
        Object object = notifier;
        synchronized (object) {
            try {
                writeThread1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = notifier;
        synchronized (object) {
            try {
                writeThread2.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (writeThread1.isAlive() || writeThread2.isAlive()) continue;
            done = true;
        }
        WriteOperationTest.assertFalse((boolean)writeThread1.isFailed());
        WriteOperationTest.assertFalse((boolean)writeThread2.isFailed());
        WriteOperationTest.assertTrue((boolean)writeThread1.isExecuted());
        WriteOperationTest.assertTrue((boolean)writeThread2.isExecuted());
        WriteOperationTest.assertTrue((Constants.occurredAfter(writeThread1, writeThread2) || Constants.occurredBefore(writeThread1, writeThread2) ? 1 : 0) != 0);
    }

    public void testNestedWrites() {
        NestedWriteThread writeThread1 = new NestedWriteThread(this.getDomain());
        writeThread1.start();
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (writeThread1.isAlive()) continue;
            done = true;
        }
        WriteOperationTest.assertFalse((boolean)writeThread1.isInnerFailed());
        WriteOperationTest.assertFalse((boolean)writeThread1.isFailed());
        WriteOperationTest.assertTrue((boolean)writeThread1.isInnerExecuted());
        WriteOperationTest.assertTrue((boolean)writeThread1.isExecuted());
        WriteOperationTest.assertTrue((boolean)Constants.occurredDuring(writeThread1.getStartTime(), writeThread1.getEndTime(), writeThread1.getInnerStartTime(), writeThread1.getInnerEndTime()));
    }
}

