/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.multithread.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.transaction.multithread.tests.AbstractMultithreadTest;
import org.eclipse.emf.transaction.multithread.tests.Constants;
import org.eclipse.emf.transaction.multithread.tests.LongRunningReadThread;
import org.eclipse.emf.transaction.multithread.tests.NestedReadThread;
import org.eclipse.emf.transaction.multithread.tests.ReadThread;

public class ReadOperationTest
extends AbstractMultithreadTest {
    public static Test suite() {
        return new TestSuite(ReadOperationTest.class, "Reader Thread Tests");
    }

    public void testReadOperation() {
        ReadThread readThread1 = new ReadThread(this.getDomain());
        readThread1.start();
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (readThread1.isAlive()) continue;
            done = true;
        }
        ReadOperationTest.assertFalse((boolean)readThread1.isFailed());
        ReadOperationTest.assertTrue((boolean)readThread1.isExecuted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimultaneousRead() {
        Object notifier = new Object();
        ReadThread readThread1 = new ReadThread(this.getDomain(), null, notifier);
        ReadThread readThread2 = new ReadThread(this.getDomain(), null, notifier);
        Object object = notifier;
        synchronized (object) {
            try {
                readThread1.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = notifier;
        synchronized (object) {
            try {
                readThread2.start();
                notifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (readThread1.isAlive() || readThread2.isAlive()) continue;
            done = true;
        }
        ReadOperationTest.assertFalse((boolean)readThread1.isFailed());
        ReadOperationTest.assertFalse((boolean)readThread2.isFailed());
        ReadOperationTest.assertTrue((boolean)readThread1.isExecuted());
        ReadOperationTest.assertTrue((boolean)readThread2.isExecuted());
        ReadOperationTest.assertTrue((Constants.occurredBefore(readThread2, readThread1) || Constants.occurredAfter(readThread2, readThread1) ? 1 : 0) != 0);
    }

    public void testNestedReads() {
        NestedReadThread readThread1 = new NestedReadThread(this.getDomain());
        readThread1.start();
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (readThread1.isAlive()) continue;
            done = true;
        }
        ReadOperationTest.assertFalse((boolean)readThread1.isInnerFailed());
        ReadOperationTest.assertFalse((boolean)readThread1.isFailed());
        ReadOperationTest.assertTrue((boolean)readThread1.isInnerExecuted());
        ReadOperationTest.assertTrue((boolean)readThread1.isExecuted());
        ReadOperationTest.assertTrue((boolean)Constants.occurredDuring(readThread1.getStartTime(), readThread1.getEndTime(), readThread1.getInnerStartTime(), readThread1.getInnerEndTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongRunningYieldingRead() {
        Object runNotifier = new Object();
        LongRunningReadThread longReadThread = new LongRunningReadThread(this.getDomain(), null, runNotifier);
        ReadThread readThd1 = new ReadThread(this.getDomain(), null, runNotifier);
        ReadThread readThd2 = new ReadThread(this.getDomain(), null, runNotifier);
        ReadThread readThd3 = new ReadThread(this.getDomain(), null, runNotifier);
        Object object = runNotifier;
        synchronized (object) {
            try {
                longReadThread.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = runNotifier;
        synchronized (object) {
            try {
                readThd1.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = runNotifier;
        synchronized (object) {
            try {
                readThd2.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = runNotifier;
        synchronized (object) {
            try {
                readThd3.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (longReadThread.isAlive() || readThd1.isAlive() || readThd2.isAlive() || readThd3.isAlive()) continue;
            done = true;
        }
        ReadOperationTest.assertFalse((boolean)longReadThread.isFailed());
        ReadOperationTest.assertFalse((boolean)readThd1.isFailed());
        ReadOperationTest.assertFalse((boolean)readThd2.isFailed());
        ReadOperationTest.assertFalse((boolean)readThd3.isFailed());
        ReadOperationTest.assertTrue((boolean)longReadThread.isExecuted());
        ReadOperationTest.assertTrue((boolean)readThd1.isExecuted());
        ReadOperationTest.assertTrue((boolean)readThd2.isExecuted());
        ReadOperationTest.assertTrue((boolean)readThd3.isExecuted());
        ReadOperationTest.assertTrue((boolean)Constants.occurredDuring(longReadThread, readThd1));
        ReadOperationTest.assertTrue((boolean)Constants.occurredDuring(longReadThread, readThd2));
        ReadOperationTest.assertTrue((boolean)Constants.occurredDuring(longReadThread, readThd3));
        ReadOperationTest.assertTrue((!Constants.occurIntersect(readThd1, readThd2) ? 1 : 0) != 0);
        ReadOperationTest.assertTrue((!Constants.occurIntersect(readThd1, readThd3) ? 1 : 0) != 0);
        ReadOperationTest.assertTrue((!Constants.occurIntersect(readThd2, readThd3) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleLongRunningYieldingReads() {
        Object runNotifier = new Object();
        LongRunningReadThread longReadThread1 = new LongRunningReadThread(this.getDomain(), null, runNotifier);
        LongRunningReadThread longReadThread2 = new LongRunningReadThread(this.getDomain(), null, runNotifier);
        LongRunningReadThread longReadThread3 = new LongRunningReadThread(this.getDomain(), null, runNotifier);
        LongRunningReadThread longReadThread4 = new LongRunningReadThread(this.getDomain(), null, runNotifier);
        Object object = runNotifier;
        synchronized (object) {
            try {
                longReadThread1.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = runNotifier;
        synchronized (object) {
            try {
                longReadThread2.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = runNotifier;
        synchronized (object) {
            try {
                longReadThread3.start();
                runNotifier.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        object = runNotifier;
        synchronized (object) {
            longReadThread4.run();
        }
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (longReadThread1.isAlive() || longReadThread2.isAlive() || longReadThread3.isAlive() || longReadThread4.isAlive()) continue;
            done = true;
        }
        ReadOperationTest.assertFalse((boolean)longReadThread1.isFailed());
        ReadOperationTest.assertFalse((boolean)longReadThread2.isFailed());
        ReadOperationTest.assertFalse((boolean)longReadThread3.isFailed());
        ReadOperationTest.assertFalse((boolean)longReadThread4.isFailed());
        ReadOperationTest.assertTrue((boolean)longReadThread1.isExecuted());
        ReadOperationTest.assertTrue((boolean)longReadThread2.isExecuted());
        ReadOperationTest.assertTrue((boolean)longReadThread3.isExecuted());
        ReadOperationTest.assertTrue((boolean)longReadThread4.isExecuted());
        int yielded = 0;
        if (longReadThread1.timeYielded >= 100L) {
            ++yielded;
        }
        if (longReadThread2.timeYielded >= 100L) {
            ++yielded;
        }
        if (longReadThread3.timeYielded >= 100L) {
            ++yielded;
        }
        if (longReadThread4.timeYielded >= 100L) {
            ++yielded;
        }
        ReadOperationTest.assertTrue((yielded >= 2 ? 1 : 0) != 0);
    }
}

