/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests.fixtures;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.workspace.tests.TestsPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCapture {
    private final Bundle targetBundle;
    private final ILogListener listener = new ILogListener(){

        public void logging(IStatus status, String plugin) {
            if (status.getPlugin().equals(LogCapture.this.targetBundle.getSymbolicName())) {
                LogCapture.this.record(status);
            }
        }
    };
    private final TransactionalCommandStack stack;
    private final List<IStatus> logs = new ArrayList<IStatus>();
    private IStatus lastLog;

    public LogCapture(Bundle targetBundle) {
        this(null, targetBundle);
    }

    public LogCapture(TransactionalCommandStack stack) {
        this(stack, TestsPlugin.instance.getBundle());
    }

    public LogCapture(TransactionalCommandStack stack, Bundle targetBundle) {
        this.targetBundle = targetBundle;
        this.stack = stack;
        if (stack != null) {
            stack.setExceptionHandler(new ExceptionHandler(){

                public void handleException(Exception e) {
                    if (e instanceof RollbackException) {
                        TestsPlugin.instance.getLog().log(((RollbackException)e).getStatus());
                    } else {
                        TestsPlugin.instance.getLog().log((IStatus)new Status(4, TestsPlugin.instance.getBundle().getSymbolicName(), 1, "Uncaught exception", (Throwable)e));
                    }
                }
            });
        }
        Platform.addLogListener((ILogListener)this.listener);
    }

    public void stop() {
        Platform.removeLogListener((ILogListener)this.listener);
        if (this.stack != null) {
            this.stack.setExceptionHandler(null);
        }
    }

    public IStatus getLastLog() {
        return this.lastLog;
    }

    public List<IStatus> getLogs() {
        return this.logs;
    }

    public void assertLogged(Throwable throwable) {
        IStatus log = this.getLastLog();
        Assert.assertNotNull((Object)log);
        log = this.findStatus(log, throwable);
        Assert.assertNotNull((Object)log);
    }

    private void record(IStatus log) {
        this.logs.add(log);
        this.lastLog = log;
    }

    private IStatus findStatus(IStatus status, Throwable exception) {
        IStatus result;
        Object object = result = status.getException() == exception ? status : null;
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (result == null && i < children.length) {
                result = this.findStatus(children[i], exception);
                ++i;
            }
        }
        return result;
    }
}

