/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExecutableXMIHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.Typedef;
import org.eclipse.ocl.cst.CSTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledUnit {
    private List<String> fQname;
    private URI fUri;
    private List<QvtMessage> fAllProblems;
    private List<CompiledUnit> fImports;
    private List<QvtOperationalModuleEnv> moduleEnvs;
    UnitCS fUnitCST;

    CompiledUnit(List<String> qualifiedName, URI uri, List<? extends QvtOperationalModuleEnv> modules) {
        if (qualifiedName == null || modules == null || uri == null) {
            throw new IllegalArgumentException();
        }
        this.fUri = uri;
        this.fQname = qualifiedName;
        this.moduleEnvs = new ArrayList<QvtOperationalModuleEnv>(modules);
        ArrayList<QvtMessage> problems = new ArrayList<QvtMessage>();
        this.fAllProblems = problems;
        for (QvtOperationalModuleEnv qvtOperationalModuleEnv : modules) {
            this.fAllProblems.addAll(qvtOperationalModuleEnv.getAllProblemMessages());
        }
        if (!problems.isEmpty()) {
            problems.trimToSize();
        }
    }

    public static ResourceSet createResourceSet() {
        return new ResourceSetImpl(){

            protected void demandLoad(Resource resource) throws IOException {
                super.demandLoad(resource);
                if ("xmi".equals(resource.getURI().fileExtension())) {
                    ExecutableXMIHelper.fixResourceOnLoad(resource);
                }
            }
        };
    }

    public CompiledUnit(URI xmiURI) {
        this(CompiledUnit.createResourceSet().getResource(xmiURI, true));
    }

    CompiledUnit(Resource unitXMIResource) {
        this.fUri = unitXMIResource.getURI();
        this.moduleEnvs = new LinkedList<QvtOperationalModuleEnv>();
        for (EObject rootElement : new ArrayList(unitXMIResource.getContents())) {
            if (!(rootElement instanceof Module)) continue;
            Module nextModule = (Module)rootElement;
            QvtOperationalModuleEnv nextModuleEnv = QvtOperationalEnvFactory.INSTANCE.createModuleEnvironment(nextModule);
            QVTOTypeResolver typeResolver = nextModuleEnv.getTypeResolver();
            ASTBindingHelper.createCST2ASTBinding((CSTNode)CSTFactory.eINSTANCE.createLibraryCS(), nextModule, nextModuleEnv);
            for (EOperation nextOper : nextModule.getEOperations()) {
                ImperativeOperation imperativeOper;
                EClassifier ctxType;
                if (!(nextOper instanceof ImperativeOperation) || (ctxType = QvtOperationalParserUtil.getContextualType(imperativeOper = (ImperativeOperation)nextOper)) == null) continue;
                typeResolver.resolveAdditionalOperation(ctxType, imperativeOper);
            }
            for (EClassifier nextClassifier : nextModule.getEClassifiers()) {
                Typedef typedef;
                if (!(nextClassifier instanceof Typedef) || (typedef = (Typedef)nextClassifier).getBase() == null) continue;
                for (EOperation next : typedef.getEOperations()) {
                    typeResolver.resolveAdditionalOperation(typedef.getBase(), next);
                }
            }
            this.moduleEnvs.add(nextModuleEnv);
        }
        this.fAllProblems = Collections.emptyList();
        this.fImports = new LinkedList<CompiledUnit>();
    }

    private static List<URI> computeImports(Resource importer) {
        Module module = (Module)importer.getContents().get(0);
        UniqueEList importURIs = new UniqueEList();
        EList<ModuleImport> imports = module.getModuleImport();
        for (ModuleImport nextImport : imports) {
            Module importedModule = nextImport.getImportedModule();
            if (importedModule == null || importedModule.eResource() == null) continue;
            URI uri = importedModule.eResource().getURI();
            importURIs.add((Object)uri);
        }
        return importURIs;
    }

    void addProblem(QvtMessage problem) {
        if (problem == null) {
            throw new IllegalArgumentException();
        }
        this.fAllProblems.add(problem);
    }

    void setImports(List<CompiledUnit> imports) {
        this.fImports = imports;
    }

    List<String> getQualifiedName() {
        return this.fQname;
    }

    public String getName() {
        return this.fQname.get(this.fQname.size() - 1);
    }

    public List<QvtOperationalModuleEnv> getModuleEnvironments() {
        return this.moduleEnvs;
    }

    public List<QvtMessage> getErrors() {
        ArrayList<QvtMessage> errors = new ArrayList<QvtMessage>();
        for (QvtMessage nextMessage : this.fAllProblems) {
            if (nextMessage.getSeverity() != 2) continue;
            errors.add(nextMessage);
        }
        return errors;
    }

    public List<QvtMessage> getWarnings() {
        ArrayList<QvtMessage> warnings = new ArrayList<QvtMessage>();
        for (QvtMessage nextMessage : this.fAllProblems) {
            if (nextMessage.getSeverity() != 1) continue;
            warnings.add(nextMessage);
        }
        return warnings;
    }

    public List<CompiledUnit> getCompiledImports() {
        return this.fImports != null ? this.fImports : Collections.emptyList();
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>(this.moduleEnvs.size());
        for (QvtOperationalModuleEnv next : this.moduleEnvs) {
            if (next.getModuleContextType() == null) continue;
            modules.add(next.getModuleContextType());
        }
        return modules;
    }

    public URI getURI() {
        return this.fUri;
    }

    public UnitCS getUnitCST() {
        return this.fUnitCST;
    }

    public List<QvtMessage> getProblems() {
        return this.fAllProblems;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompiledUnit) {
            CompiledUnit another = (CompiledUnit)obj;
            return this.fUri.equals((Object)another.fUri);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fUri.hashCode();
    }

    public String toString() {
        return this.fUri.toString();
    }
}

