/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.AbstractRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionAnalysis
extends AbstractRegionAnalysis {
    protected final @NonNull Region region;
    private @Nullable Iterable<@NonNull PartitionAnalysis> partitionAnalyses = null;
    private final @NonNull List<@NonNull NavigableEdge> corollaryEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> corollaryNodes = new ArrayList<Node>();

    public RegionAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull Region region) {
        super(transformationAnalysis);
        this.region = region;
        if (!region.isLoadingRegion()) {
            List<@NonNull Node> alreadyRealized = this.analyze();
            this.analyzeCorollaries(alreadyRealized);
        }
    }

    private void analyzeCorollaries(@NonNull List<@NonNull Node> alreadyRealizedNodes) {
        int i = 0;
        while (i < alreadyRealizedNodes.size()) {
            Node alreadyRealizedNode = alreadyRealizedNodes.get(i);
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)alreadyRealizedNode)) {
                NavigationEdge navigationEdge;
                Node targetNode;
                if (!edge.isRealized() || !edge.isNavigation() || !(targetNode = QVTscheduleUtil.getTargetNode((Edge)(navigationEdge = (NavigationEdge)edge))).isRealized() || targetNode.isSuccess()) continue;
                assert (!this.corollaryEdges.contains(navigationEdge));
                this.corollaryEdges.add((NavigableEdge)navigationEdge);
                if (!alreadyRealizedNodes.contains(targetNode)) {
                    alreadyRealizedNodes.add(targetNode);
                    assert (!this.corollaryNodes.contains(targetNode));
                    if (!this.corollaryNodes.contains(targetNode)) {
                        this.corollaryNodes.add(targetNode);
                    }
                }
                this.transformationAnalysis.addCorollary(navigationEdge);
            }
            ++i;
        }
    }

    public @Nullable Iterable<@NonNull PartitionAnalysis> basicGetPartitionAnalyses() {
        return this.partitionAnalyses;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createLocalSuccess() {
        @NonNull Iterable traceNodes = this.getTraceNodes();
        assert (traceNodes.size() == 1);
        Node traceNode = (Node)ClassUtil.nonNullState((Object)((Node)traceNodes.get(0)));
        Rule referredRule = QVTscheduleUtil.getReferredRule((RuleRegion)((RuleRegion)this.region));
        RelationAnalysis relationAnalysis = (RelationAnalysis)this.transformationAnalysis.getRuleAnalysis(referredRule);
        RelationAnalysis2TraceGroup relationAnalysis2traceGroup = relationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2TraceClass relationAnalysis2TraceClass = relationAnalysis2traceGroup.getRuleAnalysis2TraceClass();
        Element2MiddleProperty relation2localSuccessProperty = relationAnalysis2TraceClass.basicGetRelation2LocalSuccessProperty();
        Property localSuccessProperty = this.scheduleManager.basicGetLocalSuccessProperty(traceNode);
        if (relation2localSuccessProperty == null) {
            String localSuccessPropertyName = relationAnalysis2traceGroup.getNameGenerator().createTraceLocalSuccessPropertyName();
            relation2localSuccessProperty = relationAnalysis2TraceClass.createRelation2LocalSuccessProperty(localSuccessPropertyName);
            localSuccessProperty = relation2localSuccessProperty.getTraceProperty();
            SuccessEdge localSuccessEdge = relationAnalysis.createRealizedSuccess(traceNode, localSuccessProperty, null);
            QVTscheduleUtil.getTargetNode((Edge)localSuccessEdge).setUtility(Node.Utility.STRONGLY_MATCHED);
            this.analyzeLocalSuccessEdge(traceNode);
        }
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getCorollaryEdges() {
        return this.corollaryEdges;
    }

    public @NonNull Iterable<@NonNull Node> getCorollaryNodes() {
        return this.corollaryNodes;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>> getExplicitPredecessors() {
        return null;
    }

    public @NonNull String getName() {
        return String.valueOf(this.region);
    }

    @Override
    protected @NonNull Iterable<@NonNull Edge> getPartialEdges() {
        return QVTscheduleUtil.getOwnedEdges((Region)this.region);
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getPartialNodes() {
        return QVTscheduleUtil.getOwnedNodes((Region)this.region);
    }

    public @NonNull Iterable<@NonNull PartitionAnalysis> getPartitionAnalyses() {
        return (Iterable)ClassUtil.nonNullState(this.partitionAnalyses);
    }

    public @NonNull PartitionedTransformationAnalysis getPartitionedTransformationAnalysis() {
        return this.getPartitionAnalyses().iterator().next().getPartitionedTransformationAnalysis();
    }

    @Override
    public @NonNull Region getRegion() {
        return this.region;
    }

    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public void setPartitionAnalyses(@NonNull Iterable<@NonNull PartitionAnalysis> partitionAnalyses) {
        assert (this.partitionAnalyses == null);
        this.partitionAnalyses = partitionAnalyses;
    }

    public String toString() {
        return this.region.toString();
    }
}

