/*******************************************************************************
 * Copyright (c) 2018 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Adolfo Sanchez-Barbudo Herrera - initial API and implementation
 *******************************************************************************/
/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.qvtd.doc.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.qvtd.doc.minioclcs.AccVarCS;
import org.eclipse.qvtd.doc.minioclcs.BooleanExpCS;
import org.eclipse.qvtd.doc.minioclcs.CallExpCS;
import org.eclipse.qvtd.doc.minioclcs.ClassCS;
import org.eclipse.qvtd.doc.minioclcs.CollectExpCS;
import org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS;
import org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS;
import org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS;
import org.eclipse.qvtd.doc.minioclcs.EqualityExpCS;
import org.eclipse.qvtd.doc.minioclcs.ImportCS;
import org.eclipse.qvtd.doc.minioclcs.IntLiteralExpCS;
import org.eclipse.qvtd.doc.minioclcs.InvariantCS;
import org.eclipse.qvtd.doc.minioclcs.IterateExpCS;
import org.eclipse.qvtd.doc.minioclcs.IteratorVarCS;
import org.eclipse.qvtd.doc.minioclcs.LetExpCS;
import org.eclipse.qvtd.doc.minioclcs.LetVarCS;
import org.eclipse.qvtd.doc.minioclcs.MinioclcsPackage;
import org.eclipse.qvtd.doc.minioclcs.MultiplicityCS;
import org.eclipse.qvtd.doc.minioclcs.NameExpCS;
import org.eclipse.qvtd.doc.minioclcs.NullLiteralExpCS;
import org.eclipse.qvtd.doc.minioclcs.OperationCS;
import org.eclipse.qvtd.doc.minioclcs.PackageCS;
import org.eclipse.qvtd.doc.minioclcs.ParameterCS;
import org.eclipse.qvtd.doc.minioclcs.PathElementCS;
import org.eclipse.qvtd.doc.minioclcs.PathNameCS;
import org.eclipse.qvtd.doc.minioclcs.PropertyCS;
import org.eclipse.qvtd.doc.minioclcs.RootCS;
import org.eclipse.qvtd.doc.minioclcs.RoundedBracketClauseCS;
import org.eclipse.qvtd.doc.minioclcs.SelfExpCS;
import org.eclipse.qvtd.doc.services.MiniOCLCSGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class MiniOCLCSSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private MiniOCLCSGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == MinioclcsPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case MinioclcsPackage.ACC_VAR_CS:
				sequence_AccVarCS(context, (AccVarCS) semanticObject); 
				return; 
			case MinioclcsPackage.BOOLEAN_EXP_CS:
				sequence_BooleanLiteralExpCS(context, (BooleanExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.CALL_EXP_CS:
				sequence_CallExpCS(context, (CallExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.CLASS_CS:
				sequence_ClassCS(context, (ClassCS) semanticObject); 
				return; 
			case MinioclcsPackage.COLLECT_EXP_CS:
				sequence_CollectExpCS(context, (CollectExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.COLLECTION_LITERAL_EXP_CS:
				sequence_CollectionLiteralExpCS(context, (CollectionLiteralExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.COLLECTION_LITERAL_PART_CS:
				sequence_CollectionLiteralPartCS(context, (CollectionLiteralPartCS) semanticObject); 
				return; 
			case MinioclcsPackage.CONSTRAINTS_DEF_CS:
				sequence_ConstraintsDefCS(context, (ConstraintsDefCS) semanticObject); 
				return; 
			case MinioclcsPackage.EQUALITY_EXP_CS:
				sequence_EqualityExpCS(context, (EqualityExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.IMPORT_CS:
				sequence_ImportCS(context, (ImportCS) semanticObject); 
				return; 
			case MinioclcsPackage.INT_LITERAL_EXP_CS:
				sequence_IntLiteralExpCS(context, (IntLiteralExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.INVARIANT_CS:
				sequence_InvariantCS(context, (InvariantCS) semanticObject); 
				return; 
			case MinioclcsPackage.ITERATE_EXP_CS:
				sequence_IterateExpCS(context, (IterateExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.ITERATOR_VAR_CS:
				sequence_IteratorVarCS(context, (IteratorVarCS) semanticObject); 
				return; 
			case MinioclcsPackage.LET_EXP_CS:
				sequence_LetExpCS(context, (LetExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.LET_VAR_CS:
				sequence_LetVarCS(context, (LetVarCS) semanticObject); 
				return; 
			case MinioclcsPackage.MULTIPLICITY_CS:
				sequence_MultiplicityCS(context, (MultiplicityCS) semanticObject); 
				return; 
			case MinioclcsPackage.NAME_EXP_CS:
				sequence_NameExpCS(context, (NameExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.NULL_LITERAL_EXP_CS:
				sequence_NullLiteralExpCS(context, (NullLiteralExpCS) semanticObject); 
				return; 
			case MinioclcsPackage.OPERATION_CS:
				sequence_OperationCS(context, (OperationCS) semanticObject); 
				return; 
			case MinioclcsPackage.PACKAGE_CS:
				sequence_PackageCS(context, (PackageCS) semanticObject); 
				return; 
			case MinioclcsPackage.PARAMETER_CS:
				sequence_ParameterCS(context, (ParameterCS) semanticObject); 
				return; 
			case MinioclcsPackage.PATH_ELEMENT_CS:
				sequence_PathElementCS(context, (PathElementCS) semanticObject); 
				return; 
			case MinioclcsPackage.PATH_NAME_CS:
				sequence_PathNameCS(context, (PathNameCS) semanticObject); 
				return; 
			case MinioclcsPackage.PROPERTY_CS:
				sequence_PropertyCS(context, (PropertyCS) semanticObject); 
				return; 
			case MinioclcsPackage.ROOT_CS:
				sequence_RootCS(context, (RootCS) semanticObject); 
				return; 
			case MinioclcsPackage.ROUNDED_BRACKET_CLAUSE_CS:
				sequence_RoundedBracketClauseCS(context, (RoundedBracketClauseCS) semanticObject); 
				return; 
			case MinioclcsPackage.SELF_EXP_CS:
				sequence_SelfExpCS(context, (SelfExpCS) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     AccVarCS returns AccVarCS
	 *
	 * Constraint:
	 *     (accName=ID accType=PathNameCS? accInitExp=ExpCS)
	 */
	protected void sequence_AccVarCS(ISerializationContext context, AccVarCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns BooleanExpCS
	 *     EqualityExpCS returns BooleanExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns BooleanExpCS
	 *     CallExpCS returns BooleanExpCS
	 *     CallExpCS.CallExpCS_1_0 returns BooleanExpCS
	 *     PrimaryExpCS returns BooleanExpCS
	 *     LiteralExpCS returns BooleanExpCS
	 *     BooleanLiteralExpCS returns BooleanExpCS
	 *
	 * Constraint:
	 *     boolSymbol?='true'?
	 */
	protected void sequence_BooleanLiteralExpCS(ISerializationContext context, BooleanExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns CallExpCS
	 *     EqualityExpCS returns CallExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns CallExpCS
	 *     CallExpCS returns CallExpCS
	 *     CallExpCS.CallExpCS_1_0 returns CallExpCS
	 *
	 * Constraint:
	 *     (source=CallExpCS_CallExpCS_1_0 (opName='.' | opName='->') navExp=NavigationExpCS)
	 */
	protected void sequence_CallExpCS(ISerializationContext context, CallExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ClassCS returns ClassCS
	 *
	 * Constraint:
	 *     (name=ID extends=PathNameCS? (properties+=PropertyCS | operations+=OperationCS)*)
	 */
	protected void sequence_ClassCS(ISerializationContext context, ClassCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     NavigationExpCS returns CollectExpCS
	 *     LoopExpCS returns CollectExpCS
	 *     CollectExpCS returns CollectExpCS
	 *
	 * Constraint:
	 *     (itVar=IteratorVarCS? exp=ExpCS)
	 */
	protected void sequence_CollectExpCS(ISerializationContext context, CollectExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns CollectionLiteralExpCS
	 *     EqualityExpCS returns CollectionLiteralExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns CollectionLiteralExpCS
	 *     CallExpCS returns CollectionLiteralExpCS
	 *     CallExpCS.CallExpCS_1_0 returns CollectionLiteralExpCS
	 *     PrimaryExpCS returns CollectionLiteralExpCS
	 *     LiteralExpCS returns CollectionLiteralExpCS
	 *     CollectionLiteralExpCS returns CollectionLiteralExpCS
	 *
	 * Constraint:
	 *     (kind=CollectionKindCS parts+=CollectionLiteralPartCS*)
	 */
	protected void sequence_CollectionLiteralExpCS(ISerializationContext context, CollectionLiteralExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     CollectionLiteralPartCS returns CollectionLiteralPartCS
	 *
	 * Constraint:
	 *     (first=ExpCS last=ExpCS?)
	 */
	protected void sequence_CollectionLiteralPartCS(ISerializationContext context, CollectionLiteralPartCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ConstraintsDefCS returns ConstraintsDefCS
	 *
	 * Constraint:
	 *     (typeRef=PathNameCS invariants+=InvariantCS*)
	 */
	protected void sequence_ConstraintsDefCS(ISerializationContext context, ConstraintsDefCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns EqualityExpCS
	 *     EqualityExpCS returns EqualityExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns EqualityExpCS
	 *
	 * Constraint:
	 *     (left=EqualityExpCS_EqualityExpCS_1_0 (opName='=' | opName='<>') right=CallExpCS)
	 */
	protected void sequence_EqualityExpCS(ISerializationContext context, EqualityExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ImportCS returns ImportCS
	 *
	 * Constraint:
	 *     (alias=ID uri=STRING)
	 */
	protected void sequence_ImportCS(ISerializationContext context, ImportCS semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.IMPORT_CS__ALIAS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.IMPORT_CS__ALIAS));
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.IMPORT_CS__URI) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.IMPORT_CS__URI));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getImportCSAccess().getAliasIDTerminalRuleCall_1_0_0(), semanticObject.getAlias());
		feeder.accept(grammarAccess.getImportCSAccess().getUriSTRINGTerminalRuleCall_2_0(), semanticObject.getUri());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns IntLiteralExpCS
	 *     EqualityExpCS returns IntLiteralExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns IntLiteralExpCS
	 *     CallExpCS returns IntLiteralExpCS
	 *     CallExpCS.CallExpCS_1_0 returns IntLiteralExpCS
	 *     PrimaryExpCS returns IntLiteralExpCS
	 *     LiteralExpCS returns IntLiteralExpCS
	 *     IntLiteralExpCS returns IntLiteralExpCS
	 *
	 * Constraint:
	 *     intSymbol=INT
	 */
	protected void sequence_IntLiteralExpCS(ISerializationContext context, IntLiteralExpCS semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.INT_LITERAL_EXP_CS__INT_SYMBOL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.INT_LITERAL_EXP_CS__INT_SYMBOL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIntLiteralExpCSAccess().getIntSymbolINTTerminalRuleCall_0(), semanticObject.getIntSymbol());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     InvariantCS returns InvariantCS
	 *
	 * Constraint:
	 *     exp=ExpCS
	 */
	protected void sequence_InvariantCS(ISerializationContext context, InvariantCS semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.INVARIANT_CS__EXP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.INVARIANT_CS__EXP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getInvariantCSAccess().getExpExpCSParserRuleCall_2_0(), semanticObject.getExp());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     NavigationExpCS returns IterateExpCS
	 *     LoopExpCS returns IterateExpCS
	 *     IterateExpCS returns IterateExpCS
	 *
	 * Constraint:
	 *     (itVar=IteratorVarCS accVar=AccVarCS exp=ExpCS)
	 */
	protected void sequence_IterateExpCS(ISerializationContext context, IterateExpCS semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.LOOP_EXP_CS__IT_VAR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.LOOP_EXP_CS__IT_VAR));
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.ITERATE_EXP_CS__ACC_VAR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.ITERATE_EXP_CS__ACC_VAR));
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.LOOP_EXP_CS__EXP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.LOOP_EXP_CS__EXP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIterateExpCSAccess().getItVarIteratorVarCSParserRuleCall_2_0(), semanticObject.getItVar());
		feeder.accept(grammarAccess.getIterateExpCSAccess().getAccVarAccVarCSParserRuleCall_4_0(), semanticObject.getAccVar());
		feeder.accept(grammarAccess.getIterateExpCSAccess().getExpExpCSParserRuleCall_6_0(), semanticObject.getExp());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     IteratorVarCS returns IteratorVarCS
	 *
	 * Constraint:
	 *     (itName=ID itType=PathNameCS?)
	 */
	protected void sequence_IteratorVarCS(ISerializationContext context, IteratorVarCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns LetExpCS
	 *     EqualityExpCS returns LetExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns LetExpCS
	 *     CallExpCS returns LetExpCS
	 *     CallExpCS.CallExpCS_1_0 returns LetExpCS
	 *     PrimaryExpCS returns LetExpCS
	 *     LetExpCS returns LetExpCS
	 *
	 * Constraint:
	 *     (letVars+=LetVarCS letVars+=LetVarCS* inExp=ExpCS)
	 */
	protected void sequence_LetExpCS(ISerializationContext context, LetExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LetVarCS returns LetVarCS
	 *
	 * Constraint:
	 *     (name=ID typeRef=PathNameCS? initExp=ExpCS)
	 */
	protected void sequence_LetVarCS(ISerializationContext context, LetVarCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     MultiplicityCS returns MultiplicityCS
	 *
	 * Constraint:
	 *     (opt?='?' | mult?='*' | mandatory=INT | (lowerInt=INT (upperInt=INT | upperMult?='*')))
	 */
	protected void sequence_MultiplicityCS(ISerializationContext context, MultiplicityCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns NameExpCS
	 *     EqualityExpCS returns NameExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns NameExpCS
	 *     CallExpCS returns NameExpCS
	 *     CallExpCS.CallExpCS_1_0 returns NameExpCS
	 *     PrimaryExpCS returns NameExpCS
	 *     NavigationExpCS returns NameExpCS
	 *     NameExpCS returns NameExpCS
	 *
	 * Constraint:
	 *     (expName=PathNameCS roundedBrackets=RoundedBracketClauseCS?)
	 */
	protected void sequence_NameExpCS(ISerializationContext context, NameExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns NullLiteralExpCS
	 *     EqualityExpCS returns NullLiteralExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns NullLiteralExpCS
	 *     CallExpCS returns NullLiteralExpCS
	 *     CallExpCS.CallExpCS_1_0 returns NullLiteralExpCS
	 *     PrimaryExpCS returns NullLiteralExpCS
	 *     LiteralExpCS returns NullLiteralExpCS
	 *     NullLiteralExpCS returns NullLiteralExpCS
	 *
	 * Constraint:
	 *     {NullLiteralExpCS}
	 */
	protected void sequence_NullLiteralExpCS(ISerializationContext context, NullLiteralExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OperationCS returns OperationCS
	 *
	 * Constraint:
	 *     (name=ID (params+=ParameterCS params+=ParameterCS*)? resultRef=PathNameCS body=ExpCS)
	 */
	protected void sequence_OperationCS(ISerializationContext context, OperationCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PackageCS returns PackageCS
	 *
	 * Constraint:
	 *     (name=ID (packages+=PackageCS | classes+=ClassCS)*)
	 */
	protected void sequence_PackageCS(ISerializationContext context, PackageCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ParameterCS returns ParameterCS
	 *
	 * Constraint:
	 *     (name=ID typeRef=PathNameCS)
	 */
	protected void sequence_ParameterCS(ISerializationContext context, ParameterCS semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.PARAMETER_CS__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.PARAMETER_CS__NAME));
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.PARAMETER_CS__TYPE_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.PARAMETER_CS__TYPE_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParameterCSAccess().getNameIDTerminalRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getParameterCSAccess().getTypeRefPathNameCSParserRuleCall_2_0(), semanticObject.getTypeRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PathElementCS returns PathElementCS
	 *
	 * Constraint:
	 *     elementName=ID
	 */
	protected void sequence_PathElementCS(ISerializationContext context, PathElementCS semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MinioclcsPackage.Literals.PATH_ELEMENT_CS__ELEMENT_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MinioclcsPackage.Literals.PATH_ELEMENT_CS__ELEMENT_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPathElementCSAccess().getElementNameIDTerminalRuleCall_0(), semanticObject.getElementName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PathNameCS returns PathNameCS
	 *
	 * Constraint:
	 *     (pathElements+=PathElementCS pathElements+=PathElementCS*)
	 */
	protected void sequence_PathNameCS(ISerializationContext context, PathNameCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyCS returns PropertyCS
	 *
	 * Constraint:
	 *     (name=ID typeRef=PathNameCS multiplicity=MultiplicityCS?)
	 */
	protected void sequence_PropertyCS(ISerializationContext context, PropertyCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     RootCS returns RootCS
	 *
	 * Constraint:
	 *     (imports+=ImportCS+ | (imports+=ImportCS+ (packages+=PackageCS | constraints+=ConstraintsDefCS)+))?
	 */
	protected void sequence_RootCS(ISerializationContext context, RootCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     RoundedBracketClauseCS returns RoundedBracketClauseCS
	 *
	 * Constraint:
	 *     (args+=ExpCS args+=ExpCS*)?
	 */
	protected void sequence_RoundedBracketClauseCS(ISerializationContext context, RoundedBracketClauseCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpCS returns SelfExpCS
	 *     EqualityExpCS returns SelfExpCS
	 *     EqualityExpCS.EqualityExpCS_1_0 returns SelfExpCS
	 *     CallExpCS returns SelfExpCS
	 *     CallExpCS.CallExpCS_1_0 returns SelfExpCS
	 *     PrimaryExpCS returns SelfExpCS
	 *     SelfExpCS returns SelfExpCS
	 *
	 * Constraint:
	 *     {SelfExpCS}
	 */
	protected void sequence_SelfExpCS(ISerializationContext context, SelfExpCS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
