/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.ssl;

import jakarta.ws.rs.ProcessingException;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonPClient;
import org.eclipse.microprofile.rest.client.tck.ssl.AbstractSslTest;
import org.eclipse.microprofile.rest.client.tck.ssl.HttpsServer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class SslContextTest
extends AbstractSslTest {
    @Deployment
    public static WebArchive createDeployment() {
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(SslContextTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{JsonPClient.class, HttpsServer.class, AbstractSslTest.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        SslContextTest.initializeTest(webArchive, server -> server.keyStore(serverKeystore.getAbsolutePath(), "password").trustStore(serverTruststore.getAbsolutePath(), "password"));
        return webArchive;
    }

    @Test
    public void shouldSucceedMutualSslWithValidSslContext() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().loadKeyMaterial(SslContextTest.getKeyStore(clientKeystore), "password".toCharArray()).loadTrustMaterial(SslContextTest.getKeyStore(clientTruststore), null).build();
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).sslContext(sslContext).build(JsonPClient.class)).get("1");
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailedMutualSslWithoutSslContext() {
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).build(JsonPClient.class)).get("1");
    }
}

