/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.providers;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.io.IOException;

public class ThreadedClientResponseFilter
implements ClientResponseFilter {
    public static final String RESPONSE_THREAD_ID_HEADER = "Response-Thread-ID";
    public static final String RESPONSE_THREAD_NAME_HEADER = "Response-Thread-Name";
    private String responseThreadId;
    private String responseThreadName;

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        this.responseThreadId = "" + Thread.currentThread().getId();
        clientResponseContext.getHeaders().putSingle((Object)RESPONSE_THREAD_ID_HEADER, (Object)this.responseThreadId);
        this.responseThreadName = Thread.currentThread().getName();
        clientResponseContext.getHeaders().putSingle((Object)RESPONSE_THREAD_NAME_HEADER, (Object)this.responseThreadName);
    }

    public String getResponseThreadId() {
        return this.responseThreadId;
    }

    public String getResponseThreadName() {
        return this.responseThreadName;
    }
}

