/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.ext;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultClientHeadersFactoryImplTest {
    private DefaultClientHeadersFactoryImpl impl = new DefaultClientHeadersFactoryImpl();

    @BeforeMethod
    public void unsetPropagationProperty() {
        System.clearProperty("org.eclipse.microprofile.rest.client.propagateHeaders");
    }

    private MultivaluedMap<String, String> mockIncomingHeaders() {
        MultivaluedHashMap incomingHeaders = new MultivaluedHashMap();
        incomingHeaders.putSingle((Object)"Authorization", (Object)"Basic xyz123");
        incomingHeaders.putSingle((Object)"Content-Type", (Object)"application/json");
        incomingHeaders.putSingle((Object)"Accept", (Object)"application/json");
        incomingHeaders.putSingle((Object)"Favorite-Color", (Object)"blue");
        return incomingHeaders;
    }

    private MultivaluedMap<String, String> mockOutgoingHeaders() {
        MultivaluedHashMap outgoingHeaders = new MultivaluedHashMap();
        outgoingHeaders.putSingle((Object)"Custom-Header", (Object)"my custom value");
        return outgoingHeaders;
    }

    @Test
    public void testUpdateWithNoConfigReturnsEmptyMap() {
        MultivaluedMap<String, String> incomingHeaders = this.mockIncomingHeaders();
        MultivaluedHashMap clientOutgoingHeaders = new MultivaluedHashMap();
        MultivaluedMap updatedHeaders = this.impl.update(incomingHeaders, (MultivaluedMap)clientOutgoingHeaders);
        Assert.assertNotNull((Object)updatedHeaders);
        Assert.assertEquals((int)updatedHeaders.size(), (int)0);
    }

    @Test
    public void testUpdateWithConfiguredPropagationHeaders() {
        System.setProperty("org.eclipse.microprofile.rest.client.propagateHeaders", "Authorization,Favorite-Color");
        MultivaluedMap<String, String> incomingHeaders = this.mockIncomingHeaders();
        MultivaluedHashMap clientOutgoingHeaders = new MultivaluedHashMap();
        MultivaluedMap updatedHeaders = this.impl.update(incomingHeaders, (MultivaluedMap)clientOutgoingHeaders);
        Assert.assertNotNull((Object)updatedHeaders);
        Assert.assertEquals((int)updatedHeaders.size(), (int)2);
        Assert.assertEquals((String)"Basic xyz123", (String)((String)updatedHeaders.getFirst((Object)"Authorization")));
        Assert.assertEquals((String)"blue", (String)((String)updatedHeaders.getFirst((Object)"Favorite-Color")));
    }

    @Test
    public void testUpdateWithConfiguredPropagationHeadersAndExistingOutgoingHeaders() {
        System.setProperty("org.eclipse.microprofile.rest.client.propagateHeaders", "Authorization,Favorite-Color");
        MultivaluedMap<String, String> incomingHeaders = this.mockIncomingHeaders();
        MultivaluedMap<String, String> clientOutgoingHeaders = this.mockOutgoingHeaders();
        MultivaluedMap updatedHeaders = this.impl.update(incomingHeaders, clientOutgoingHeaders);
        Assert.assertNotNull((Object)updatedHeaders);
        Assert.assertEquals((int)updatedHeaders.size(), (int)2);
        Assert.assertEquals((String)"Basic xyz123", (String)((String)updatedHeaders.getFirst((Object)"Authorization")));
        Assert.assertEquals((String)"blue", (String)((String)updatedHeaders.getFirst((Object)"Favorite-Color")));
    }
}

