/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class CancelStageVerification
extends AbstractStageVerification {
    CancelStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void cancelStageShouldCancelTheStage() {
        final CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.rs.fromPublisher(s -> s.onSubscribe(new Subscription(){

            public void request(long n) {
            }

            public void cancel() {
                cancelled.complete(null);
            }
        })).cancel().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test
    public void cancelStageShouldIgnoreAnyUpstreamFailures() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException()).cancel().run(this.getEngine()));
    }

    @Test
    public void cancelSubscriberBuilderShouldBeReusable() {
        SubscriberBuilder cancel = this.rs.builder().cancel();
        this.await(this.rs.of((Object)"a").to(cancel).run(this.getEngine()));
        this.await(this.rs.of((Object)"b").to(cancel).run(this.getEngine()));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new SubscriberVerification());
    }

    public class SubscriberVerification
    extends AbstractStageVerification.StageSubscriberBlackboxVerification {
        public SubscriberVerification() {
            super(CancelStageVerification.this);
        }

        public Subscriber createSubscriber() {
            return CancelStageVerification.this.rs.builder().cancel().build(CancelStageVerification.this.getEngine());
        }

        public Object createElement(int element) {
            return element;
        }

        public void required_spec201_blackbox_mustSignalDemandViaSubscriptionRequest() throws Throwable {
            throw new SkipException("Cancel subscriber does not need to signal demand.");
        }

        public void required_spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithPrecedingRequestCall() throws Throwable {
            throw new SkipException("Cancel subscriber does not need to signal demand.");
        }

        public void required_spec210_blackbox_mustBePreparedToReceiveAnOnErrorSignalWithPrecedingRequestCall() throws Throwable {
            throw new SkipException("Cancel subscriber does not need to signal demand.");
        }
    }
}

