/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SimpleTimerTest {
    @Inject
    private MetricRegistry registry;
    private static SimpleTimer globalTimer = null;
    private static boolean isInitialized = false;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void initData() {
        if (isInitialized) {
            return;
        }
        globalTimer = this.registry.simpleTimer("test.longData.simpleTimer");
        isInitialized = true;
    }

    @Test
    @InSequence(value=1)
    public void testTime() throws Exception {
        SimpleTimer simpleTimer = this.registry.simpleTimer("testSimpleTime");
        double beforeStartTime = System.nanoTime();
        SimpleTimer.Context context = simpleTimer.time();
        double afterStartTime = System.nanoTime();
        Thread.sleep(1000L);
        double beforeStopTime = System.nanoTime();
        double time = context.stop();
        double afterStopTime = System.nanoTime();
        double delta = afterStartTime - beforeStartTime + (afterStopTime - beforeStopTime);
        Assert.assertEquals((double)(beforeStopTime - beforeStartTime), (double)time, (double)delta);
    }

    @Test
    @InSequence(value=2)
    public void testTimerRegistry() throws Exception {
        String simpleTimerLongName = "test.longData.simpleTimer";
        String simpleTimerTimeName = "testSimpleTime";
        MetricID simpleTimerLongNameMetricID = new MetricID(simpleTimerLongName);
        MetricID simpleTimerTimeNameMetricID = new MetricID(simpleTimerTimeName);
        Assert.assertNotNull((Object)this.registry.getSimpleTimer(simpleTimerLongNameMetricID));
        Assert.assertNotNull((Object)this.registry.getSimpleTimer(simpleTimerTimeNameMetricID));
    }

    @Test
    @InSequence(value=3)
    public void timesCallableInstances() throws Exception {
        SimpleTimer simpleTimer = this.registry.simpleTimer("testCallable");
        String value = (String)simpleTimer.time(() -> "one");
        Assert.assertEquals((long)simpleTimer.getCount(), (long)1L);
        Assert.assertEquals((Object)value, (Object)"one");
    }

    @Test
    @InSequence(value=4)
    public void timesRunnableInstances() throws Exception {
        SimpleTimer simpleTimer = this.registry.simpleTimer("testRunnable");
        AtomicBoolean called = new AtomicBoolean();
        simpleTimer.time(() -> called.set(true));
        Assert.assertEquals((long)simpleTimer.getCount(), (long)1L);
        Assert.assertEquals((Object)called.get(), (Object)true);
    }
}

