/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.util;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.jwt.tck.util.SignatureAlgorithm;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenUtilsSignEncryptTest {
    @Test(groups={"utils"}, description="Illustrate an encryption of the nested JWT")
    public void testEncryptSignedClaims() throws Exception {
        String token = TokenUtils.signEncryptClaims((String)"/Token1.json");
        this.validateToken(token, true);
    }

    @Test(groups={"utils"}, description="Illustrate an encryption of the nested JWT")
    public void testEncryptECSignedClaims() throws Exception {
        String token = TokenUtils.signEncryptClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.ES256);
        this.validateToken(token, SignatureAlgorithm.ES256, true);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT", expectedExceptions={InvalidJwtException.class})
    public void testNestedSignedByRSKeyVerifiedByECKey() throws Exception {
        String token = TokenUtils.signEncryptClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256);
        this.validateToken(token, SignatureAlgorithm.ES256, true);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT", expectedExceptions={InvalidJwtException.class})
    public void testNestedSignedByECKeyVerifiedByRSKey() throws Exception {
        String token = TokenUtils.signEncryptClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.ES256);
        this.validateToken(token, SignatureAlgorithm.RS256, true);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation failure if signed token is encrypted and no 'cty' header is set")
    public void testEncryptSignedClaimsWithoutCty() throws Exception {
        RSAPrivateKey signingKey = TokenUtils.readPrivateKey((String)"/privateKey.pem");
        RSAPublicKey encryptionKey = TokenUtils.readPublicKey((String)"/publicKey.pem");
        String token = TokenUtils.signEncryptClaims((PrivateKey)signingKey, (String)"1", (PublicKey)encryptionKey, (String)"2", (String)"/Token1.json", (boolean)false);
        this.validateToken(token, true);
    }

    @Test(groups={"utils"}, expectedExceptions={JoseException.class}, description="Illustrate validation failure if signed token is used")
    public void testValidateSignedToken() throws Exception {
        String token = TokenUtils.signClaims((String)"/Token1.json");
        this.validateToken(token, false);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation failure if encrypted token without nested token is used")
    public void testValidateEncryptedOnlyToken() throws Exception {
        String token = TokenUtils.encryptClaims((String)"/Token1.json");
        this.validateToken(token, false);
    }

    private void validateToken(String jweCompact, boolean jwtExpected) throws Exception {
        this.validateToken(jweCompact, SignatureAlgorithm.RS256, jwtExpected);
    }

    private void validateToken(String jweCompact, SignatureAlgorithm signatureAlgorithm, boolean jwtExpected) throws Exception {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RSA-OAEP"}));
        jwe.setCompactSerialization(jweCompact);
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey.pem");
        jwe.setKey((Key)privateKey);
        String token = jwe.getPlaintextString();
        if (jwtExpected) {
            if (!"JWT".equals(jwe.getHeader("cty"))) {
                throw new InvalidJwtException("'cty' header is missing", Collections.emptyList(), null);
            }
        } else {
            Assert.assertNull((Object)jwe.getHeader("cty"));
        }
        PublicKey publicKey = signatureAlgorithm == SignatureAlgorithm.RS256 ? TokenUtils.readPublicKey((String)"/publicKey.pem") : TokenUtils.readECPublicKey((String)"/ecPublicKey.pem");
        int expGracePeriodSecs = 60;
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setRequireExpirationTime();
        builder.setSkipDefaultAudienceValidation();
        builder.setRequireIssuedAt();
        builder.setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{signatureAlgorithm.getAlgorithm()}));
        builder.setExpectedIssuer(true, "https://server.example.com");
        builder.setVerificationKey((Key)publicKey);
        builder.setAllowedClockSkewInSeconds(expGracePeriodSecs);
        JwtClaims claimsSet = builder.build().processToClaims(token);
        Assert.assertEquals((int)claimsSet.getClaimsMap().size(), (int)19);
        Assert.assertEquals((String)claimsSet.getIssuer(), (String)"https://server.example.com");
        Assert.assertEquals((String)claimsSet.getJwtId(), (String)"a-123");
        Assert.assertEquals((String)claimsSet.getSubject(), (String)"24400320");
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("upn"), (String)"jdoe@example.com");
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("preferred_username"), (String)"jdoe");
        Assert.assertEquals((int)claimsSet.getAudience().size(), (int)1);
        Assert.assertEquals((String)((String)claimsSet.getAudience().get(0)), (String)"s6BhdRkqt3");
        Assert.assertNotNull((Object)claimsSet.getExpirationTime());
        long exp = claimsSet.getExpirationTime().getValue();
        Assert.assertEquals((long)claimsSet.getIssuedAt().getValue(), (long)(exp - 300L));
        Assert.assertEquals((long)NumericDate.fromSeconds((long)((Long)claimsSet.getClaimValue("auth_time", Long.class))).getValue(), (long)(exp - 300L));
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("customString"), (String)"customStringValue");
        Assert.assertEquals((Object)claimsSet.getClaimValue("customInteger", Long.class), (Object)123456789L);
        Assert.assertEquals((Object)claimsSet.getClaimValue("customDouble", Double.class), (Object)Math.PI);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("roles")).size(), (int)1);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("groups")).size(), (int)4);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customStringArray")).size(), (int)3);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customIntegerArray")).size(), (int)4);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customDoubleArray")).size(), (int)5);
        Assert.assertEquals((int)((Map)claimsSet.getClaimsMap().get("customObject")).size(), (int)3);
    }
}

