/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class SimpleTokenUtils {
    private SimpleTokenUtils() {
    }

    public static PrivateKey decodePrivateKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = SimpleTokenUtils.toEncodedBytes(pemEncoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }

    public static RSAPublicKey decodePublicKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = SimpleTokenUtils.toEncodedBytes(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)kf.generatePublic(spec);
    }

    public static ECPublicKey decodeECPublicKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = SimpleTokenUtils.toEncodedBytes(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("EC");
        return (ECPublicKey)kf.generatePublic(spec);
    }

    public static RSAPublicKey decodeJWKSPublicKey(String jwksValue) throws Exception {
        JsonObject jwks = Json.createReader((Reader)new StringReader(jwksValue)).readObject();
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? keys.getJsonObject(0) : jwks;
        String e = jwk.getString("e");
        String n = jwk.getString("n");
        byte[] ebytes = Base64.getUrlDecoder().decode(e);
        BigInteger publicExponent = new BigInteger(1, ebytes);
        byte[] nbytes = Base64.getUrlDecoder().decode(n);
        BigInteger modulus = new BigInteger(1, nbytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        return (RSAPublicKey)kf.generatePublic(rsaPublicKeySpec);
    }

    public static PrivateKey decodeJWKSPrivateKey(String jwksValue) throws Exception {
        JsonObject jwks = Json.createReader((Reader)new StringReader(jwksValue)).readObject();
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? keys.getJsonObject(0) : jwks;
        String d = jwk.getString("d");
        String n = jwk.getString("n");
        byte[] dbytes = Base64.getUrlDecoder().decode(d);
        BigInteger privateExponent = new BigInteger(1, dbytes);
        byte[] nbytes = Base64.getUrlDecoder().decode(n);
        BigInteger modulus = new BigInteger(1, nbytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(modulus, privateExponent);
        return kf.generatePrivate(rsaPrivateKeySpec);
    }

    private static byte[] toEncodedBytes(String pemEncoded) {
        String normalizedPem = SimpleTokenUtils.removeBeginEnd(pemEncoded);
        return Base64.getDecoder().decode(normalizedPem);
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    public static String readResource(String resName) throws IOException {
        if (resName.startsWith("classpath:")) {
            resName = resName.substring(10);
        }
        InputStream is = SimpleTokenUtils.class.getResourceAsStream(resName);
        StringWriter sw = new StringWriter();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line = br.readLine();
            while (line != null) {
                sw.write(line);
                sw.write(10);
                line = br.readLine();
            }
        }
        return sw.toString();
    }
}

