/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClassLevelClientForMaxRetries;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientForMaxRetries;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientWithDelay;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientWithNoDelayAndJitter;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryTest
extends Arquillian {
    @Inject
    private RetryClientForMaxRetries clientForMaxRetry;
    @Inject
    private RetryClientWithDelay clientForDelay;
    @Inject
    private RetryClassLevelClientForMaxRetries clientForClassLevelMaxRetry;
    @Inject
    private RetryClientWithNoDelayAndJitter retryClientWithNoDelayAndJitter;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(RetryClientWithDelay.class, "serviceA");
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetry.jar")).addClasses(new Class[]{RetryClientForMaxRetries.class, RetryClientWithDelay.class, RetryClassLevelClientForMaxRetries.class, RetryClientWithNoDelayAndJitter.class, TestException.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetry.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryMaxRetries() {
        try {
            this.clientForMaxRetry.serviceA();
            Assert.fail((String)"serviceA should throw a TestException in testRetryMaxRetries");
        }
        catch (TestException testException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForMaxRetry.getRetryCountForConnectionService(), (int)6, (String)"The max number of execution should be 6");
    }

    @Test
    public void testRetryMaxDuration() {
        try {
            this.clientForMaxRetry.serviceB();
            Assert.fail((String)"serviceB should throw a TestException in testRetryMaxDuration");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retries = this.clientForMaxRetry.getRetryCountForWritingService();
        Assert.assertTrue((retries < 11 ? 1 : 0) != 0, (String)("The max retry counter should be less than 11 but it was " + retries));
    }

    @Test
    public void testRetryMaxDurationSeconds() {
        try {
            this.clientForMaxRetry.serviceC();
            Assert.fail((String)"serviceC should throw a TestException in testRetryMaxDuration");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retries = this.clientForMaxRetry.getRetryCountForWritingService();
        Assert.assertTrue((retries < 11 ? 1 : 0) != 0, (String)("The max retry counter should be less than 11 but it was " + retries));
    }

    @Test
    public void testRetryWithDelay() {
        try {
            this.clientForDelay.serviceA();
            Assert.fail((String)"serviceA should throw a TestException in testRetryWithDelay");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retryCountForConnectionService = this.clientForDelay.getRetryCountForConnectionService();
        Assert.assertTrue((retryCountForConnectionService > 4 ? 1 : 0) != 0, (String)("The max number of execution should be greater than 4 but it was " + retryCountForConnectionService));
        this.clientForDelay.assertDelayInRange();
    }

    @Test
    public void testRetryWithNoDelayAndJitter() {
        try {
            this.retryClientWithNoDelayAndJitter.serviceA();
            Assert.fail((String)"serviceA should throw a TestException in testRetryWithDelay");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retryCountForConnectionService = this.retryClientWithNoDelayAndJitter.getRetryCountForConnectionService();
        Assert.assertTrue((this.retryClientWithNoDelayAndJitter.positiveDelays() > 0 ? 1 : 0) != 0, (String)"Using jitter must cause some effective delay even when delay is set to 0");
        Assert.assertTrue((retryCountForConnectionService > 8 && retryCountForConnectionService < 100 ? 1 : 0) != 0, (String)("The max number of execution should be between 8 and 100 but it was " + retryCountForConnectionService + ". Too many retries mean jitter is not being applied."));
    }

    @Test
    public void testClassLevelRetryMaxRetries() {
        try {
            this.clientForClassLevelMaxRetry.serviceA();
            Assert.fail((String)"serviceA should throw a TestException in testClassLevelRetryMaxRetries");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retries = this.clientForClassLevelMaxRetry.getRetryCountForConnectionService();
        Assert.assertEquals((int)retries, (int)3, (String)("The max number of execution should be 3 but it was " + retries));
    }

    @Test
    public void testClassLevelRetryMaxDuration() {
        try {
            this.clientForClassLevelMaxRetry.serviceB();
            Assert.fail((String)"serviceB should throw a TestException in testClassLevelRetryMaxDuration");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retryCountforWritingService = this.clientForClassLevelMaxRetry.getRetryCountForWritingService();
        Assert.assertTrue((retryCountforWritingService < 11 ? 1 : 0) != 0, (String)("The max retry counter should be less than 11 but it was " + retryCountforWritingService));
        Assert.assertTrue((retryCountforWritingService > 3 ? 1 : 0) != 0, (String)("The max retry counter should be greater than 3 but it was " + retryCountforWritingService));
    }

    @Test
    public void testClassLevelRetryMaxDurationSeconds() {
        try {
            this.clientForClassLevelMaxRetry.serviceC();
            Assert.fail((String)"serviceC should throw a TestException in testClassLevelRetryMaxDurationSeconds");
        }
        catch (TestException testException) {
            // empty catch block
        }
        int retries = this.clientForClassLevelMaxRetry.getRetryCountForWritingService();
        Assert.assertTrue((retries < 11 ? 1 : 0) != 0, (String)("The max retry counter should be less than 11 but it was" + retries));
    }
}

