/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.tck.contexts.buffer.Buffer;
import org.eclipse.microprofile.context.tck.contexts.label.Label;
import org.testng.Assert;

@ApplicationScoped
public class CDIBean {
    static final long MAX_WAIT_SEC = 120L;
    @Inject
    @AppProducedExecutor
    ManagedExecutor appProduced;
    @Inject
    @LabelContextPropagator
    ThreadContext labelContextPropagator;
    @Inject
    @Priority3Executor
    Executor priority3Executor;

    public void testVerifyInjection() {
        Assert.assertNotNull((Object)this.appProduced);
    }

    public void testBasicExecutorUsable() throws Exception {
        Assert.assertEquals((String)((String)this.appProduced.supplyAsync(() -> "hello").get(120L, TimeUnit.SECONDS)), (String)"hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppDefinedProducerOfThreadContext() {
        Assert.assertNotNull((Object)this.labelContextPropagator, (String)"Application should be able to use qualifier to obtain produced instance of ThreadContext.");
        int originalPriority = Thread.currentThread().getPriority();
        int newPriority = originalPriority == 2 ? 1 : 2;
        try {
            Thread.currentThread().setPriority(newPriority);
            Label.set("testAppDefinedProducerOfThreadContext-label");
            Buffer.set(new StringBuffer("testAppDefinedProducerOfThreadContext-buffer"));
            Runnable testLabelContext = this.labelContextPropagator.contextualRunnable(() -> {
                Assert.assertEquals((String)Label.get(), (String)"testAppDefinedProducerOfThreadContext-label", (String)"Thread context type was not propagated.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Thread context type (Buffer) was not cleared.");
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)5, (String)"Thread context type (ThreadPriority) was not cleared.");
            });
            Label.set("testAppDefinedProducerOfThreadContext-new-label");
            testLabelContext.run();
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    public void testAppDefinedProducerUsingInjectedThreadContext() {
        Assert.assertNotNull((Object)this.priority3Executor, (String)"Application should be able to create its own CDI producer that injects a ThreadContext.");
        int originalPriority = Thread.currentThread().getPriority();
        int newPriority = originalPriority == 2 ? 1 : 2;
        try {
            Thread.currentThread().setPriority(newPriority);
            Label.set("testAppDefinedProducerUsingInjectedThreadContext-label");
            Buffer.set(new StringBuffer("testAppDefinedProducerUsingInjectedThreadContext-buffer"));
            this.priority3Executor.execute(() -> {
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)3, (String)"Thread context type was not propagated.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Thread context type (Label) was not cleared.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Thread context type (Buffer) was not cleared.");
            });
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Priority3Executor {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface PriorityContext {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface LabelContextPropagator {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface AppProducedExecutor {
    }
}

