/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.tck.contexts.buffer.Buffer;
import org.eclipse.microprofile.context.tck.contexts.label.Label;

@ApplicationScoped
public class MPConfigBean {
    protected CompletableFuture<Integer> completedFuture;
    protected Executor contextSnapshot;

    @Inject
    protected void setCompletedFuture(@Max5Queue ManagedExecutor executor) {
        this.completedFuture = executor.completedFuture((Object)100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    protected void setContextSnapshot(@Named(value="producedThreadContext") ThreadContext contextPropagator) {
        int originalPriority = Thread.currentThread().getPriority();
        int newPriority = originalPriority == 4 ? 3 : 4;
        Thread.currentThread().setPriority(newPriority);
        Label.set("setContextSnapshot-test-label");
        Buffer.set(new StringBuffer("setContextSnapshot-test-buffer"));
        try {
            this.contextSnapshot = contextPropagator.currentContextExecutor();
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    public CompletableFuture<Integer> getCompletedFuture() {
        return this.completedFuture;
    }

    public Executor getContextSnapshot() {
        return this.contextSnapshot;
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Max5Queue {
    }
}

