/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class TargetNamespace_2CodeAction
implements ICodeActionParticipant {
    private static final Pattern NAMESPACE_EXTRACTOR = Pattern.compile("'([^']+)'\\.");

    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        String namespace = TargetNamespace_2CodeAction.extractNamespace(diagnostic.getMessage());
        if (StringUtils.isEmpty(namespace)) {
            return;
        }
        DOMElement root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        SharedSettings sharedSettings = request.getSharedSettings();
        Position tagEnd = XMLPositionUtility.selectStartTagName(root).getEnd();
        String quote = sharedSettings.getPreferences().getQuotationAsString();
        CodeAction addNamespaceDecl = CodeActionFactory.insert("Declare '" + namespace + "' as the namespace", tagEnd, " xmlns=" + quote + namespace + quote, document.getTextDocument(), diagnostic);
        codeActions.add(addNamespaceDecl);
    }

    private static String extractNamespace(String diagnosticMessage) {
        Matcher nsMatcher = NAMESPACE_EXTRACTOR.matcher(diagnosticMessage);
        if (nsMatcher.find()) {
            return nsMatcher.group(1);
        }
        return null;
    }
}

