/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.validator;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;

public class RelaxNGErrorHandler
implements XMLErrorHandler {
    private XMLErrorReporter report;

    public RelaxNGErrorHandler(XMLErrorReporter report) {
        this.report = report;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        this.reportError(domain, key, (short)0, exception);
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        this.reportError(domain, key, (short)2, exception);
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        this.reportError(domain, key, (short)1, exception);
    }

    private void reportError(String domain, String key, short severity, XMLParseException exception) {
        String message;
        if (domain.isEmpty() && key.isEmpty() && !(message = exception.getMessage()).isEmpty()) {
            RelaxNGReportInfo info = RelaxNGErrorHandler.getRelaxNGReportInfo(message);
            this.report.reportError("https://relaxng.org/", info.errorCode.getCode(), info.arguments, severity, (Exception)((Object)exception));
            return;
        }
        this.report.reportError(domain, key, null, severity, (Exception)((Object)exception));
    }

    private static RelaxNGReportInfo getRelaxNGReportInfo(String message) {
        if (message.startsWith("element")) {
            if (message.contains(" not allowed anywhere")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.unknown_element, new Object[0]);
            }
            if (message.contains("not allowed yet; missing required element ")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.unexpected_element_required_element_missing, new Object[0]);
            }
            if (message.contains("incomplete; missing required elements")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.incomplete_element_required_elements_missing, new Object[0]);
            }
            if (message.contains("incomplete; missing required element")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.incomplete_element_required_element_missing, new Object[0]);
            }
            if (message.contains("incomplete")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.incomplete_element_required_elements_missing_expected, new Object[0]);
            }
            if (message.contains("not allowed here")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.out_of_context_element, new Object[0]);
            }
            if (message.contains("missing one or more required attributes")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.required_attributes_missing_expected, new Object[0]);
            }
            if (message.contains("missing required attributes ")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.required_attributes_missing, new Object[0]);
            }
            if (message.contains("missing required attribute ")) {
                return new RelaxNGReportInfo(RelaxNGErrorCode.required_attribute_missing, new Object[0]);
            }
        }
        if (message.startsWith("found attribute")) {
            String attrName = RelaxNGErrorHandler.extractArg("found attribute", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.no_attributes_allowed, attrName);
        }
        if (message.startsWith("attribute") && message.contains(" not allowed here")) {
            String attrName = RelaxNGErrorHandler.extractArg("attribute", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.invalid_attribute_name, attrName);
        }
        if (message.startsWith("value of attribute ")) {
            String attrName = RelaxNGErrorHandler.extractArg("value of attribute ", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.invalid_attribute_value, attrName);
        }
        if (message.startsWith("multiple definitions of start")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.duplicate_start, new Object[0]);
        }
        if (message.startsWith("multiple definitions of")) {
            String defineName = RelaxNGErrorHandler.extractArg("multiple definitions of ", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.duplicate_define, defineName);
        }
        if (message.contains("from library") && message.endsWith("not recognized")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.unrecognized_datatype, new Object[0]);
        }
        if (message.equals("missing \"start\" element")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.missing_start_element, new Object[0]);
        }
        if (message.startsWith("reference to undefined pattern")) {
            String patternName = RelaxNGErrorHandler.extractArg("reference to undefined pattern ", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.reference_to_undefined, patternName);
        }
        if (message.startsWith("found ") && message.endsWith("element but expected a pattern")) {
            String tagName = RelaxNGErrorHandler.extractArg("found ", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.expected_pattern, tagName);
        }
        if (message.startsWith("illegal attribute ")) {
            String attrName = RelaxNGErrorHandler.extractArg("illegal attribute ", message);
            return new RelaxNGReportInfo(RelaxNGErrorCode.illegal_attribute_ignored, attrName);
        }
        if (message.equals("illegal \"name\" attribute")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.illegal_name_attribute, new Object[0]);
        }
        if (message.endsWith("is not a valid local name")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.invalid_ncname, new Object[0]);
        }
        if (message.endsWith("missing children")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.missing_children, new Object[0]);
        }
        if (message.equals("missing \"name\" attribute")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.missing_name_attribute, new Object[0]);
        }
        if (message.endsWith("expected child element specifying name class")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.missing_name_class, new Object[0]);
        }
        if (message.equals("missing \"type\" attribute")) {
            return new RelaxNGReportInfo(RelaxNGErrorCode.missing_type_attribute, new Object[0]);
        }
        return new RelaxNGReportInfo(RelaxNGErrorCode.to_implement, new Object[0]);
    }

    private static String extractArg(String from, String message) {
        int fromIndex = message.indexOf(from) + from.length();
        StringBuilder arg = null;
        for (int i = fromIndex; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '\"') {
                if (arg != null) break;
                arg = new StringBuilder();
                continue;
            }
            if (arg == null) continue;
            arg.append(c);
        }
        return arg != null ? arg.toString() : null;
    }

    private static class RelaxNGReportInfo {
        public final RelaxNGErrorCode errorCode;
        public final Object[] arguments;

        public RelaxNGReportInfo(RelaxNGErrorCode errorCode, Object ... arguments) {
            this.errorCode = errorCode;
            this.arguments = arguments;
        }
    }
}

