/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.completion;

import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLFileAssociationCompletionBasedOnRelaxNGCompactSyntaxTest
extends AbstractCacheBasedTest {
    @Test
    public void completionInRoot() throws BadLocationException {
        String xml = "<|";
        XMLFileAssociationCompletionBasedOnRelaxNGCompactSyntaxTest.testCompletionFor(xml, XMLAssert.c("addressBook", XMLAssert.te(0, 0, 0, 1, "<addressBook></addressBook>"), "<addressBook"));
    }

    @Test
    public void completionForElements() throws BadLocationException {
        String xml = "<addressBook>\r\n<|\r\n</addressBook>";
        XMLFileAssociationCompletionBasedOnRelaxNGCompactSyntaxTest.testCompletionFor(xml, XMLAssert.c("card", XMLAssert.te(1, 0, 1, 1, "<card></card>"), "<card"));
    }

    @Test
    public void completionForAttributeNames() throws BadLocationException {
        String xml = "<addressBook>\r\n<card |></card>\r\n</addressBook>";
        XMLFileAssociationCompletionBasedOnRelaxNGCompactSyntaxTest.testCompletionFor(xml, XMLAssert.c("id", XMLAssert.te(1, 6, 1, 6, "id=\"\""), "id"));
    }

    private static void testCompletionFor(String value, CompletionItem ... expectedItems) throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationCompletionBasedOnRelaxNGCompactSyntaxTest.createXMLFileAssociation("src/test/resources/relaxng/"));
        };
        XMLAssert.testCompletionFor(new XMLLanguageService(), value, null, configuration, "file:///test/addressBook.xml", null, true, expectedItems);
    }

    private static XMLFileAssociation[] createXMLFileAssociation(String baseSystemId) {
        XMLFileAssociation addressBook = new XMLFileAssociation();
        addressBook.setPattern("**/addressBook.xml");
        addressBook.setSystemId(baseSystemId + "addressBook.rnc");
        return new XMLFileAssociation[]{addressBook};
    }
}

