/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadedException;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.CacheResourceException;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public abstract class AbstractReferencedGrammarLSPErrorReporter
extends AbstractLSPErrorReporter {
    protected final ContentModelManager contentModelManager;
    private final Map<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache;
    private final boolean hasRelatedInformation;

    public AbstractReferencedGrammarLSPErrorReporter(String source, DOMDocument xmlDocument, List<Diagnostic> diagnostics, ContentModelManager contentModelManager, boolean hasRelatedInformation, Map<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache) {
        super(source, xmlDocument, diagnostics, hasRelatedInformation);
        this.contentModelManager = contentModelManager;
        this.hasRelatedInformation = hasRelatedInformation;
        this.referencedGrammarDiagnosticsInfoCache = referencedGrammarDiagnosticsInfoCache == null ? new HashMap() : referencedGrammarDiagnosticsInfoCache;
    }

    @Override
    protected Range toLSPRange(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, DOMDocument document) {
        String documentOrGrammarURI;
        boolean errorForDocument = (documentOrGrammarURI = location.getExpandedSystemId()) != null ? documentOrGrammarURI.endsWith(document.getDocumentURI()) : true;
        Range range = this.toLSPRange(location, key, arguments, message, diagnosticSeverity, fatalError, document, documentOrGrammarURI, errorForDocument);
        if (range != null) {
            return range;
        }
        if (!errorForDocument) {
            return NO_RANGE;
        }
        return null;
    }

    protected void fillReferencedGrammarDiagnostic(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, URIResolverExtensionManager resolverExtensionManager, XMLSyntaxErrorCode syntaxCode, XMLSchemaErrorCode schemaErrorCode, DTDErrorCode dtdCode, XSDErrorCode xsdCode, String grammarURI) {
        ReferencedGrammarDiagnosticsInfo info = this.getReferencedGrammarDiagnosticsInfo(grammarURI, resolverExtensionManager);
        if (info.isFatalError()) {
            return;
        }
        info.addError(fatalError);
        if (this.hasRelatedInformation && info.getGrammarDocument() != null) {
            DOMDocument grammarDocument = info.getGrammarDocument();
            Range range = null;
            range = schemaErrorCode != null ? XMLSchemaErrorCode.toLSPRange(location, schemaErrorCode, arguments, grammarDocument) : (dtdCode != null ? DTDErrorCode.toLSPRange(location, dtdCode, arguments, grammarDocument) : (xsdCode != null ? XSDErrorCode.toLSPRange(location, xsdCode, arguments, grammarDocument) : XMLSyntaxErrorCode.toLSPRange(location, syntaxCode, arguments, grammarDocument)));
            if (range == null) {
                range = this.createDefaultRange(location, grammarDocument);
            }
            if (range == null) {
                try {
                    range = new Range(new Position(0, 0), grammarDocument.positionAt(grammarDocument.getEnd()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            DiagnosticRelatedInformation r = new DiagnosticRelatedInformation(range != null ? new Location(grammarURI, range) : null, message);
            info.addDiagnosticRelatedInformation(r);
        }
    }

    private ReferencedGrammarDiagnosticsInfo getReferencedGrammarDiagnosticsInfo(String grammarURI, URIResolverExtensionManager resolverExtensionManager) {
        ReferencedGrammarDiagnosticsInfo info = this.referencedGrammarDiagnosticsInfoCache.get(grammarURI);
        if (info == null) {
            Range range = this.getReferencedGrammarRange(grammarURI);
            String message = "";
            Diagnostic diagnostic = super.addDiagnostic(range, message, DiagnosticSeverity.Error, null, null);
            info = new ReferencedGrammarDiagnosticsInfo(grammarURI, resolverExtensionManager, diagnostic);
            this.referencedGrammarDiagnosticsInfoCache.put(grammarURI, info);
        }
        return info;
    }

    public void endReport() {
        if (this.referencedGrammarDiagnosticsInfoCache.isEmpty()) {
            return;
        }
        LSPXMLGrammarPool grammarPool = this.contentModelManager.getGrammarPool();
        if (grammarPool == null) {
            return;
        }
        Set<String> grammarURIs = this.referencedGrammarDiagnosticsInfoCache.keySet();
        for (String grammarURI : grammarURIs) {
            grammarPool.removeGrammar(grammarURI);
        }
    }

    @Override
    protected String getMessage(String domain, String key, Object[] arguments, Exception exception) {
        IOException e;
        Throwable cause;
        if (this.isReferencedGrammarError(key) && exception instanceof IOException && (cause = (e = (IOException)exception).getCause()) instanceof CacheResourceException) {
            return cause.getMessage();
        }
        return super.getMessage(domain, key, arguments, exception);
    }

    @Override
    protected DiagnosticSeverity getSeverity(String domain, String key, Object[] arguments, short severity, Exception exception) {
        IOException e;
        Throwable cause;
        if (this.isReferencedGrammarError(key) && exception instanceof IOException && (cause = (e = (IOException)exception).getCause()) instanceof CacheResourceException) {
            if (cause instanceof CacheResourceDownloadingException && ((CacheResourceDownloadingException)cause).getErrorCode() == CacheResourceDownloadingException.CacheResourceDownloadingError.RESOURCE_LOADING) {
                return DiagnosticSeverity.Information;
            }
            return DiagnosticSeverity.Error;
        }
        return super.getSeverity(domain, key, arguments, severity, exception);
    }

    @Override
    protected String getCode(String domain, String key, Object[] arguments, Exception exception) {
        IOException e;
        Throwable cause;
        if (this.isReferencedGrammarError(key) && exception instanceof IOException && (cause = (e = (IOException)exception).getCause()) instanceof CacheResourceException) {
            if (cause instanceof CacheResourceDownloadingException) {
                switch (((CacheResourceDownloadingException)cause).getErrorCode()) {
                    case DOWNLOAD_DISABLED: {
                        return ExternalResourceErrorCode.DownloadResourceDisabled.getCode();
                    }
                    case RESOURCE_LOADING: {
                        return ExternalResourceErrorCode.DownloadingResource.getCode();
                    }
                    case RESOURCE_NOT_IN_DEPLOYED_PATH: {
                        return ExternalResourceErrorCode.ResourceNotInDeployedPath.getCode();
                    }
                }
            } else if (cause instanceof CacheResourceDownloadedException) {
                switch (((CacheResourceDownloadedException)cause).getErrorCode()) {
                    case ERROR_WHILE_DOWNLOADING: {
                        return ExternalResourceErrorCode.DownloadProblem.getCode();
                    }
                }
            }
        }
        return super.getCode(domain, key, arguments, exception);
    }

    private boolean isReferencedGrammarError(String key) {
        return DTDErrorCode.get(key) == DTDErrorCode.DTDNotFound || XMLSchemaErrorCode.get(key) == XMLSchemaErrorCode.schema_reference_4;
    }

    protected abstract Range toLSPRange(XMLLocator var1, String var2, Object[] var3, String var4, DiagnosticSeverity var5, boolean var6, DOMDocument var7, String var8, boolean var9);

    protected abstract Range getReferencedGrammarRange(String var1);
}

