/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.FileServer;
import org.eclipse.lsp4j.Range;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DTDHoverExtensionsTest {
    @Test
    public void testTagHover() throws BadLocationException, URI.MalformedURIException {
        String dtdURI = DTDHoverExtensionsTest.getDTDFileURI("liferay-service-builder_7_2_0.dtd");
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE service-builder PUBLIC \"-//Liferay//DTD Service Builder 7.2.0//EN\" \"http://www.liferay.com/dtd/liferay-service-builder_7_2_0.dtd\"><service-builder dependency-injector=\"ds\" package-path=\"testSB\"></servi|ce-builder>";
        DTDHoverExtensionsTest.assertHover(xml, "The service-builder element is the root of the deployment descriptor for a Service Builder descriptor that is used to generate services available to portlets. The Service Builder saves the developer time by generating Spring utilities, SOAP utilities, and Hibernate persistence classes to ease the development of services." + System.lineSeparator() + System.lineSeparator() + "Source: [liferay-service-builder_7_2_0.dtd](" + dtdURI + ")", XMLAssert.r(1, 206, 1, 221));
    }

    @Test
    public void testAttributeNameHover() throws BadLocationException, URI.MalformedURIException {
        String dtdURI = DTDHoverExtensionsTest.getDTDFileURI("liferay-service-builder_7_2_0.dtd");
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE service-builder PUBLIC \"-//Liferay//DTD Service Builder 7.2.0//EN\" \"http://www.liferay.com/dtd/liferay-service-builder_7_2_0.dtd\"><service-builder dependency-injector=\"ds\" pa|ckage-path=\"testSB\"></service-builder>";
        DTDHoverExtensionsTest.assertHover(xml, "The package-path value specifies the package of the generated code." + System.lineSeparator() + System.lineSeparator() + "Source: [liferay-service-builder_7_2_0.dtd](" + dtdURI + ")", XMLAssert.r(1, 182, 1, 194));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void webXML() throws Exception {
        FileServer server = new FileServer();
        try {
            server.start();
            String httpDTDUri = server.getUri("/dtd/web-app_2_3.dtd");
            Path cachedFilePath = CacheResourcesManager.getResourceCachePath((String)httpDTDUri);
            Files.deleteIfExists(cachedFilePath);
            CacheResourcesManager cacheResourcesManager = new CacheResourcesManager();
            try {
                cacheResourcesManager.getResource(httpDTDUri);
                Assertions.fail((String)"Expected file to be downloading");
            }
            catch (CacheResourceDownloadingException containsFuture) {
                containsFuture.getFuture().get(30L, TimeUnit.SECONDS);
            }
            Assertions.assertTrue((boolean)Files.exists(cachedFilePath, new LinkOption[0]), (String)("'" + cachedFilePath + "' file should be downloaded in the cache."));
            String dtdFileCacheURI = cachedFilePath.toUri().toString().replace("file:///", "file:/");
            String xml = "<!DOCTYPE web-app PUBLIC\n \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\n \"" + httpDTDUri + "\" >\n\n<web-a|pp>\n  <display-name>Servlet 2.3 Web Application</display-name>\n</web-app>";
            DTDHoverExtensionsTest.assertHoverWithCache(xml, "The web-app element is the root of the deployment descriptor for a web application." + System.lineSeparator() + System.lineSeparator() + "Source: [web-app_2_3.dtd](" + dtdFileCacheURI + ")", XMLAssert.r(4, 1, 4, 8));
        }
        finally {
            server.stop();
        }
    }

    private static void assertHover(String value, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        XMLAssert.assertHover(new XMLLanguageService(), value, "src/test/resources/catalogs/catalog-liferay.xml", null, expectedHoverLabel, expectedHoverRange);
    }

    private static void assertHoverWithCache(String value, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLAssert.assertHover(new XMLLanguageService(), value, null, null, expectedHoverLabel, expectedHoverRange, settings);
    }

    private static String getDTDFileURI(String dtdURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("dtd/" + dtdURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }
}

