/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.telemetry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lemminx.utils.platform.JVM;
import org.eclipse.lemminx.utils.platform.Memory;
import org.eclipse.lemminx.utils.platform.Platform;

public class InitializationTelemetryInfo {
    public static final String JVM_MEMORY_MAX = "jvm_memory_max";
    public static final String JVM_MEMORY_TOTAL = "jvm_memory_total";
    public static final String JVM_MEMORY_FREE = "jvm_memory_free";
    public static final String JVM_IS_NATIVE_IMAGE = "server_is_native";
    public static final String JVM_RUNTIME = "jvm_runtime";
    public static final String JVM_VERSION = "jvm_version";
    public static final String JVM_NAME = "jvm_name";
    public static final String SERVER_VERSION_NUMBER = "server_version";

    public static Map<String, Object> getInitializationTelemetryInfo() {
        HashMap<String, Object> initTelemetry = new HashMap<String, Object>();
        initTelemetry.put(SERVER_VERSION_NUMBER, Platform.getVersion().getVersionNumber());
        JVM jvm = Platform.getJVM();
        initTelemetry.put(JVM_NAME, jvm.getName());
        initTelemetry.put(JVM_VERSION, jvm.getVersion());
        initTelemetry.put(JVM_RUNTIME, jvm.getRuntime());
        initTelemetry.put(JVM_IS_NATIVE_IMAGE, jvm.isNativeImage());
        Memory memory = jvm.getMemory();
        initTelemetry.put(JVM_MEMORY_FREE, memory.getFree());
        initTelemetry.put(JVM_MEMORY_TOTAL, memory.getTotal());
        initTelemetry.put(JVM_MEMORY_MAX, memory.getMax());
        return initTelemetry;
    }
}

