/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xmlmodel.contentmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.utils.StringUtils;

public class CMXMLModelContentModelProvider
implements ContentModelProvider {
    private final ContentModelManager modelManager;

    public CMXMLModelContentModelProvider(ContentModelManager modelManager) {
        this.modelManager = modelManager;
    }

    @Override
    public boolean adaptFor(DOMDocument document, boolean internal) {
        if (internal) {
            return false;
        }
        return document.hasXMLModel();
    }

    @Override
    public boolean adaptFor(String uri) {
        return false;
    }

    @Override
    public Collection<ContentModelProvider.Identifier> getIdentifiers(DOMDocument xmlDocument, String namespaceURI) {
        List<XMLModel> xmlModels = xmlDocument.getXMLModels();
        if (xmlModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ContentModelProvider.Identifier> identifiers = new ArrayList<ContentModelProvider.Identifier>();
        for (XMLModel xmlModel : xmlModels) {
            String href = xmlModel.getHref();
            if (StringUtils.isEmpty(href)) continue;
            identifiers.add(new ContentModelProvider.Identifier(null, href, xmlModel.getHrefNode(), "xml-model"));
        }
        return identifiers;
    }

    @Override
    public CMDocument createCMDocument(String uri) {
        ContentModelProvider modelProvider = this.modelManager.getModelProviderByURI(uri);
        return modelProvider != null ? modelProvider.createCMDocument(uri) : null;
    }

    @Override
    public CMDocument createInternalCMDocument(DOMDocument xmlDocument) {
        return null;
    }
}

