/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.dom.DTDNotationDecl;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

class XMLSymbolsProvider {
    private static final Logger LOGGER = Logger.getLogger(XMLSymbolsProvider.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLSymbolsProvider(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<SymbolInformation> findSymbolInformations(DOMDocument xmlDocument, CancelChecker cancelChecker) {
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        boolean isDTD = xmlDocument.isDTD();
        for (DOMNode node : xmlDocument.getRoots()) {
            try {
                this.findSymbolInformations(node, "", symbols, node.isDoctype() && isDTD, cancelChecker);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "XMLSymbolsProvider#findSymbolInformations was given a BadLocation by a 'node' variable", e);
            }
        }
        return symbols;
    }

    public List<DocumentSymbol> findDocumentSymbols(DOMDocument xmlDocument, CancelChecker cancelChecker) {
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        boolean isDTD = xmlDocument.isDTD();
        ArrayList nodesToIgnore = new ArrayList();
        xmlDocument.getRoots().forEach(node -> {
            try {
                if (node.isDoctype() && isDTD) {
                    nodesToIgnore.add(node);
                }
                this.findDocumentSymbols((DOMNode)node, (List<DocumentSymbol>)symbols, nodesToIgnore, cancelChecker);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "XMLSymbolsProvider#findDocumentSymbols was given a BadLocation by a 'node' variable", e);
            }
        });
        return symbols;
    }

    private void findDocumentSymbols(DOMNode node, List<DocumentSymbol> symbols, List<DOMNode> nodesToIgnore, CancelChecker cancelChecker) throws BadLocationException {
        if (!XMLSymbolsProvider.isNodeSymbol(node)) {
            return;
        }
        cancelChecker.checkCanceled();
        boolean hasChildNodes = node.hasChildNodes();
        List<DocumentSymbol> childrenSymbols = symbols;
        if (nodesToIgnore == null || !nodesToIgnore.contains(node)) {
            Range selectionRange;
            String name;
            if (nodesToIgnore != null && node.isDTDAttListDecl()) {
                DTDAttlistDecl decl = (DTDAttlistDecl)node;
                name = decl.getElementName();
                selectionRange = XMLSymbolsProvider.getSymbolRange(node, true);
            } else {
                name = XMLSymbolsProvider.nodeToName(node);
                selectionRange = XMLSymbolsProvider.getSymbolRange(node);
            }
            Range range = selectionRange;
            childrenSymbols = hasChildNodes || node.isDTDElementDecl() || node.isDTDAttListDecl() ? new ArrayList<DocumentSymbol>() : Collections.emptyList();
            DocumentSymbol symbol = new DocumentSymbol(name, XMLSymbolsProvider.getSymbolKind(node), range, selectionRange, null, childrenSymbols);
            symbols.add(symbol);
            if (node.isDTDElementDecl() || nodesToIgnore != null && node.isDTDAttListDecl()) {
                Collection<DOMNode> attlistDecls;
                if (node.isDTDElementDecl()) {
                    DTDElementDecl elementDecl = (DTDElementDecl)node;
                    String elementName = elementDecl.getName();
                    attlistDecls = node.getOwnerDocument().findDTDAttrList(elementName);
                } else {
                    attlistDecls = new ArrayList<DOMNode>();
                    attlistDecls.add(node);
                }
                for (DOMNode attrDecl : attlistDecls) {
                    DTDAttlistDecl decl;
                    List<DTDAttlistDecl> otherAttributeDecls;
                    this.findDocumentSymbols(attrDecl, childrenSymbols, null, cancelChecker);
                    if (attrDecl instanceof DTDAttlistDecl && (otherAttributeDecls = (decl = (DTDAttlistDecl)attrDecl).getInternalChildren()) != null) {
                        for (DTDAttlistDecl internalDecl : otherAttributeDecls) {
                            this.findDocumentSymbols(internalDecl, childrenSymbols, null, cancelChecker);
                        }
                    }
                    nodesToIgnore.add(attrDecl);
                }
            }
        }
        if (!hasChildNodes) {
            return;
        }
        List<DocumentSymbol> childrenOfChild = childrenSymbols;
        node.getChildren().forEach(child -> {
            try {
                this.findDocumentSymbols((DOMNode)child, childrenOfChild, nodesToIgnore, cancelChecker);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "XMLSymbolsProvider was given a BadLocation by the provided 'node' variable", e);
            }
        });
    }

    private void findSymbolInformations(DOMNode node, String container, List<SymbolInformation> symbols, boolean ignoreNode, CancelChecker cancelChecker) throws BadLocationException {
        if (!XMLSymbolsProvider.isNodeSymbol(node)) {
            return;
        }
        String name = "";
        if (!ignoreNode) {
            name = XMLSymbolsProvider.nodeToName(node);
            DOMDocument xmlDocument = node.getOwnerDocument();
            Range range = XMLSymbolsProvider.getSymbolRange(node);
            Location location = new Location(xmlDocument.getDocumentURI(), range);
            SymbolInformation symbol = new SymbolInformation(name, XMLSymbolsProvider.getSymbolKind(node), location, container);
            symbols.add(symbol);
        }
        String containerName = name;
        node.getChildren().forEach(child -> {
            try {
                this.findSymbolInformations((DOMNode)child, containerName, symbols, false, cancelChecker);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "XMLSymbolsProvider was given a BadLocation by the provided 'node' variable", e);
            }
        });
    }

    private static Range getSymbolRange(DOMNode node) throws BadLocationException {
        return XMLSymbolsProvider.getSymbolRange(node, false);
    }

    private static Range getSymbolRange(DOMNode node, boolean useAttlistElementName) throws BadLocationException {
        DOMDocument xmlDocument = node.getOwnerDocument();
        if (node.isDTDAttListDecl() && !useAttlistElementName) {
            DTDAttlistDecl attlistDecl = (DTDAttlistDecl)node;
            DTDDeclParameter attributeNameDecl = attlistDecl.attributeName;
            if (attributeNameDecl != null) {
                Position start = xmlDocument.positionAt(attributeNameDecl.getStart());
                Position end = xmlDocument.positionAt(attributeNameDecl.getEnd());
                return new Range(start, end);
            }
        }
        Position start = xmlDocument.positionAt(node.getStart());
        Position end = xmlDocument.positionAt(node.getEnd());
        return new Range(start, end);
    }

    private static SymbolKind getSymbolKind(DOMNode node) {
        if (node.isProcessingInstruction() || node.isProlog()) {
            return SymbolKind.Property;
        }
        if (node.isDoctype()) {
            return SymbolKind.Struct;
        }
        if (node.isDTDElementDecl()) {
            return SymbolKind.Property;
        }
        if (node.isDTDEntityDecl()) {
            return SymbolKind.Namespace;
        }
        if (node.isDTDAttListDecl()) {
            return SymbolKind.Key;
        }
        if (node.isDTDNotationDecl()) {
            return SymbolKind.Variable;
        }
        return SymbolKind.Field;
    }

    private static boolean isNodeSymbol(DOMNode node) {
        return node.isElement() || node.isDoctype() || node.isProcessingInstruction() || node.isProlog() || node.isDTDElementDecl() || node.isDTDAttListDecl() || node.isDTDEntityDecl() || node.isDTDNotationDecl();
    }

    private static String nodeToName(DOMNode node) {
        String name = null;
        if (node.isElement()) {
            name = ((Element)((Object)node)).getTagName();
        } else if (node.isProcessingInstruction() || node.isProlog()) {
            name = ((ProcessingInstruction)((Object)node)).getTarget();
        } else if (node.isDoctype()) {
            name = "DOCTYPE:" + ((DocumentType)((Object)node)).getName();
        } else if (node.isDTDElementDecl()) {
            name = ((DTDElementDecl)node).getName();
        } else if (node.isDTDAttListDecl()) {
            DTDAttlistDecl attr = (DTDAttlistDecl)node;
            name = attr.getAttributeName();
        } else if (node.isDTDEntityDecl()) {
            name = node.getNodeName();
        } else if (node.isDTDNotationDecl()) {
            DTDNotationDecl notation = (DTDNotationDecl)node;
            name = notation.getName();
        }
        return name != null ? name : "?";
    }
}

