/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.january.dataset.BooleanIteratorBase;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.InterfaceUtils;

public class BooleanNullIterator
extends BooleanIteratorBase {
    public BooleanNullIterator(Dataset a, Dataset o) {
        this(a, o, false);
    }

    public BooleanNullIterator(Dataset a, Dataset o, boolean createIfNull) {
        this(a, o, createIfNull, false, true);
    }

    public BooleanNullIterator(Dataset a, Dataset o, boolean createIfNull, boolean allowInteger, boolean allowComplex) {
        super(true, a, null, o);
        List<int[]> fullShapes = BroadcastUtils.broadcastShapes(a.getShapeRef(), o == null ? null : o.getShapeRef());
        BroadcastUtils.checkItemSize(a, o);
        this.maxShape = fullShapes.remove(0);
        this.oStride = null;
        if (o != null && !Arrays.equals(this.maxShape, o.getShapeRef())) {
            throw new IllegalArgumentException("Output does not match broadcasted shape");
        }
        this.aShape = fullShapes.remove(0);
        int rank = this.maxShape.length;
        this.endrank = rank - 1;
        this.aDataset = a.reshape(this.aShape);
        this.aStride = BroadcastUtils.createBroadcastStrides(this.aDataset, this.maxShape);
        if (this.outputA) {
            this.oStride = this.aStride;
            this.oDelta = null;
            this.oStep = 0;
        } else if (o != null) {
            this.oStride = BroadcastUtils.createBroadcastStrides(o, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = o.getElementsPerItem();
        } else if (createIfNull) {
            int is = this.aDataset.getElementsPerItem();
            Class<Object> dc = this.aDataset.getClass();
            if (this.aDataset.isComplex() && !allowComplex) {
                is = 1;
                dc = InterfaceUtils.getBestFloatInterface(dc);
            } else if (!this.aDataset.hasFloatingPointElements() && !allowInteger) {
                dc = InterfaceUtils.getBestFloatInterface(dc);
            }
            this.oDataset = DatasetFactory.zeros(is, dc, this.maxShape);
            this.oStride = BroadcastUtils.createBroadcastStrides(this.oDataset, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = is;
        } else {
            this.oDelta = null;
            this.oStep = 0;
        }
        this.pos = new int[rank];
        this.aDelta = new int[rank];
        int j = this.endrank;
        while (j >= 0) {
            this.aDelta[j] = this.aStride[j] * this.aShape[j];
            if (this.oDelta != null) {
                this.oDelta[j] = this.oStride[j] * this.maxShape[j];
            }
            --j;
        }
        this.aStart = this.aDataset.getOffset();
        this.aMax = this.endrank < 0 ? this.aStep + this.aStart : Integer.MIN_VALUE;
        this.oStart = this.oDelta == null ? 0 : this.oDataset.getOffset();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + 1;
            this.index += this.aStride[j];
            if (this.oDelta != null) {
                this.oIndex += this.oStride[j];
            }
            if (this.pos[j] < this.maxShape[j]) break;
            this.pos[j] = 0;
            this.index -= this.aDelta[j];
            if (this.oDelta != null) {
                this.oIndex -= this.oDelta[j];
            }
            --j;
        }
        if (j == -1) {
            if (this.endrank >= 0) {
                return false;
            }
            this.index += this.aStep;
            if (this.oDelta != null) {
                this.oIndex += this.oStep;
            }
        }
        if (this.outputA) {
            this.oIndex = this.index;
        }
        return this.index != this.aMax;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i <= this.endrank) {
            this.pos[i] = 0;
            ++i;
        }
        if (this.endrank >= 0) {
            this.pos[this.endrank] = -1;
            this.index = this.aStart - this.aStride[this.endrank];
            this.oIndex = this.oStart - (this.oStride == null ? 0 : this.oStride[this.endrank]);
        } else {
            this.index = this.aStart - this.aStep;
            this.oIndex = this.oStart - this.oStep;
        }
    }
}

