/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.rest.jsonb.cdi;

import ee.jakarta.tck.core.rest.jsonb.cdi.SomeMessage;
import ee.jakarta.tck.core.rest.jsonb.cdi.Utils;
import jakarta.json.JsonObject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Type;

@Provider
public class CustomJsonbResolver
implements ContextResolver<Jsonb> {
    public static final String NO_SHA256_ERROR_MSG = "No sha256 found in top level JSON object";

    public final Jsonb getContext(Class<?> type) {
        if (!SomeMessage.class.isAssignableFrom(type)) {
            return null;
        }
        System.out.printf("CustomJsonbResolver.getContext(%s)\n", type);
        return JsonbBuilder.create((JsonbConfig)new JsonbConfig().withSerializers(new JsonbSerializer[]{new CustomSerializer()}).withDeserializers(new JsonbDeserializer[]{new CustomDeserializer()}));
    }

    static final class CustomSerializer
    implements JsonbSerializer<SomeMessage> {
        CustomSerializer() {
        }

        public void serialize(SomeMessage msg, JsonGenerator generator, SerializationContext ctx) {
            String msgHash64 = null;
            try {
                msgHash64 = Utils.generateHash(msg);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to generate SHA-256", e);
            }
            System.out.printf("CustomJsonbResolver.CustomSerializer.serialize(%s); sha256=%s\n", msg, msgHash64);
            generator.writeStartObject();
            generator.write("sha256", msgHash64);
            generator.writeStartObject("msg");
            generator.write("content", msg.getMsg());
            generator.write("recipient", msg.getRecipient());
            generator.write("sender", msg.getSender());
            String signature = msg.getSignature();
            generator.write("signature", signature != null ? signature : "");
            generator.write("secure", msg.isSecure());
            generator.writeEnd();
            generator.writeEnd();
        }
    }

    static final class CustomDeserializer
    implements JsonbDeserializer<SomeMessage> {
        CustomDeserializer() {
        }

        public SomeMessage deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
            SomeMessage someMessage = new SomeMessage();
            JsonObject wrapper = parser.getObject();
            if (!wrapper.containsKey((Object)"sha256")) {
                throw new WebApplicationException(CustomJsonbResolver.NO_SHA256_ERROR_MSG, Response.Status.BAD_REQUEST);
            }
            String sha256 = wrapper.getString("sha256");
            JsonObject msg = wrapper.getJsonObject("msg");
            String content = msg.getString("content");
            String recipient = msg.getString("recipient");
            String sender = msg.getString("sender");
            String signature = msg.getString("signature");
            boolean secure = msg.getBoolean("secure");
            someMessage.setMsg(content);
            someMessage.setRecipient(recipient);
            someMessage.setSender(sender);
            someMessage.setSignature(signature);
            someMessage.setSecure(secure);
            boolean verified = Utils.verifyMsgHash(someMessage, sha256);
            someMessage.setVerified(verified);
            System.out.printf("CustomJsonbResolver.CustomDeserializer.deserialize(%s); sha256=%s\n", someMessage, sha256);
            return someMessage;
        }
    }
}

