/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.rest.jsonb.cdi;

import ee.jakarta.tck.core.rest.jsonb.cdi.SomeMessage;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;

@Path(value="/json-tests")
public class ApplicationResource {
    public static final String INVALID_SIGNATURE_ERORR = "Message signature did not verify";
    @Inject
    private PublicKey publicKey;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SomeMessage sendMessage(SomeMessage message) throws SignatureException {
        System.out.printf("ApplicationResource, msg=%s\n", message);
        SomeMessage reply = new SomeMessage();
        try {
            Signature ecdsaVerify = Signature.getInstance("SHA256withECDSA");
            ecdsaVerify.initVerify(this.publicKey);
            ecdsaVerify.update(message.getMsg().getBytes(StandardCharsets.UTF_8));
            boolean result = ecdsaVerify.verify(Base64.getDecoder().decode(message.getSignature()));
            System.out.printf("ApplicationResource, secure(%s/%s)=%s\n", message.getMsg(), message.getSignature(), result);
            reply.setSecure(result);
        }
        catch (Exception e) {
            throw new WebApplicationException("Failed during validation of", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!reply.isSecure()) {
            throw new WebApplicationException(INVALID_SIGNATURE_ERORR, Response.Status.METHOD_NOT_ALLOWED);
        }
        reply.setMsg(message.getMsg() + " ApplicationResource.reply");
        reply.setRecipient(message.getSender());
        reply.setSender("ApplicationResource.sendMessage");
        return reply;
    }
}

